#include "stdafx.h"
#include "q2chwmBbsManager.h"
#include "q2chwmDatCtrl.h"
#include "q2chwmConfig.h"
#include "q2chwmDatFile.h"
#include "q2chwmArticleFile.h"
#include "q2chwmNgFile.h"
#include "YoTime.h"
#include "q2chwmGrepDialog.h"
#include "q2chwmCacheImageFile.h"
#include "q2chwmImage.h"

#define CONVERT_BUFFER	8192

Cq2chwmDatCtrl::Cq2chwmDatCtrl(CWnd *pParent, CWnd *pMain)
: m_cArrayFromLine(1000), m_cRegexImage(_T("([h]*ttp://[!-~]+\\.(gif|jpg|jpeg|png|bmp))[^!-~]"), CYoRegex::UTF16LE, TRUE), m_lpszLine(NULL)
{
	m_pMain = pMain;
	m_pParent = pParent;
	m_cEdit.Create(m_pParent, 0, 0, 0, 0);
	m_cEdit.SetWrap(TRUE);
	m_bo_running = FALSE;
	m_in_width = 0;
	m_in_font_size = 0;
	m_bo_font_bold = FALSE;
	m_pRegex = NULL;
	m_bo_transparentabone = Cq2chwmConfig::GetInstance()->GetTransParentAbone();
	m_in_line_max = 0;
	m_hIconImage = AfxGetApp()->LoadIcon(IDI_IMAGE);

	m_cEdit.SetDrawProc((WPARAM)this, Cq2chwmDatCtrl::DrawProc);
	m_cEdit.SetGetColorProc((WPARAM)this, Cq2chwmDatCtrl::GetColorProc);
	m_cEdit.SetBeforeWindowProc((WPARAM)this, Cq2chwmDatCtrl::BeforeWindowProc);
	m_cEdit.SetAfterWindowProc((WPARAM)this, Cq2chwmDatCtrl::AfterWindowProc);
}

Cq2chwmDatCtrl::~Cq2chwmDatCtrl()
{
	if (ExistFile(GetFileName()) == TRUE) {
		Cq2chwmArticleFile cArticle;
		cArticle.Create(GetBoardUrl());
		cArticle.SetSeen(GetArticleId(), GetMessageCount(), FALSE);
		cArticle.Write();

		Write();
	}
	if (m_pRegex != NULL) delete m_pRegex;
}

int Cq2chwmDatCtrl::Reload()
{
	Clear();
	return Create(m_str_aname, m_str_aid, m_str_bname, m_str_burl, m_str_bid);
}

int Cq2chwmDatCtrl::Create(
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_burl,
	const char *chp_bid)
{
	m_str_bname = chp_bname;
	m_str_burl = chp_burl;
	m_str_bid = chp_bid;
	m_str_aname = chp_aname;
	m_str_aid = chp_aid;
	m_str_aurl = m_str_burl + m_str_aid;
	m_str_url = m_str_burl + "dat/" + m_str_aid + ".dat";
	m_str_filename = UrlToPath(chp_burl);
	m_str_filename += "\\" + m_str_aid + ".dat";

	// NG[hK\ǂݍ
	if (m_pRegex != NULL) {
		delete m_pRegex;
		m_pRegex = NULL;
	}
	CYoString str_pat = Cq2chwmNgFile::GetInstance()->GetPattern(GetBoardUrl(), GetArticleId());
	if (str_pat.Length() > 0) {
		CString cstr_pat;
		cstr_pat = (const char*)str_pat;
		m_pRegex = new CYoRegex(cstr_pat, CYoRegex::UTF16LE, TRUE);
		m_pRegex->SetReference(FALSE);
	}

	if (ExistFile(m_str_filename) == FALSE) {
		if (Cq2chwmConfig::GetInstance()->GetOnline() == TRUE ||
			::MessageBox(m_pParent->m_hWnd, _T("t@C݂܂BT[o擾܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES)
		{
			return CreateFromHttp();
		}
		return ERR_NONE;
	}
	int in_ret = CreateFromFile();
	if (in_ret != ERR_NONE) {
		return in_ret;
	}

	if (Cq2chwmConfig::GetInstance()->GetOnline() == TRUE) {
		return CreateFromHttp();
	}
	return ERR_NONE;
}

#define UNICODE_CONVERT
int Cq2chwmDatCtrl::CreateFromFile()
{
	CYoTime cTime;
	CString cstr_filename;
	cstr_filename = m_str_filename;
	CFile cFile;
	if (cFile.Open(cstr_filename, CFile::modeRead) == FALSE) {
		return ERR_FILE_OPEN;
	}

	int in_filesize = (int)cFile.GetLength();
	if (in_filesize == 0) {
		cFile.Close();
		return ERR_NONE;
	}

	// t@Cǂݍݗ̈m
	char *chp_in = (char*)malloc(sizeof(char) * in_filesize + 1);

	// ǂݍ
	cFile.Read(chp_in, in_filesize);
	chp_in[in_filesize] = 0x00;

	// infot@Cǂݍ
	if (m_cInfo.Create(GetBoardUrl(), GetArticleId()) == FALSE) {
		m_cInfo.SetNumber(1);
	}

	// Ǖ\
	int in_seen;
	if (m_cInfo.GetNew() == TRUE) {
		// VtOĂȂ{ő僌Xԍȍ~𖢓Ǖ\
		in_seen = m_cInfo.GetMax();
	} else {
		// VtOĂȂȂSĊǕ\
		in_seen = m_cInfo.GetCount();
	}

	// ϊ
#ifdef UNICODE_CONVERT
	CString str_name;
	CString cstr_in;
	cstr_in.Preallocate(in_filesize + 1);
	cstr_in = chp_in;
	CString cstr_out;
	cstr_out.Preallocate(cstr_in.GetLength() + CONVERT_BUFFER);
	int in_len = Cq2chwmDatFile::Convert(str_name, cstr_out, cstr_in, 1, in_seen + 1, m_pRegex, m_bo_transparentabone,
		NULL, NULL, &m_cMapId, &m_cMapRefer);
	if (str_name.GetLength() > 0) {
		m_str_aname = A(str_name);
		HtmlToText(m_str_aname);
	}
#else
	// NG[hK\ǂݍ
	CYoString str_pat = Cq2chwmNgFile::GetInstance()->GetPattern(GetBoardUrl(), GetArticleId());
	if (m_pRegex != NULL) delete m_pRegex;
	if (str_pat.Length() > 0) {
		m_pRegex = new CYoRegex(str_pat, CYoRegex::SJIS, TRUE);
	}

	char *chp_out = (char*)malloc(sizeof(char) * in_filesize + CONVERT_BUFFER);
	CYoString str_name;
	int in_len = Cq2chwmDatFile::Convert(str_name, chp_out, chp_in, 1, in_seen + 1, m_pRegex, m_bo_transparentabone,
		Cq2chwmConfig::GetInstance()->GetDeleteBlankLines(), NULL, NULL);
	if (str_name.Length() > 0) {
		m_str_aname = str_name;
	}
#endif
	free(chp_in);

	m_cEdit.SetAutoUpdate(FALSE);
	m_cEdit.AddText(cstr_out, in_len);
	createIndex();

	// ǈʒuփWv
	JumpNumber(m_cInfo.GetNumber());
	m_cEdit.SetAutoUpdate(TRUE);

	// {ősXV
	m_in_line_max = max(m_in_line_max, m_cEdit.GetTopLine());

	// 
	cFile.Close();

	PRINTLOG("%d(msec)", cTime.Elapsed());
	return ERR_NONE;
}

void Cq2chwmDatCtrl::createIndex(
	int in_line)
{
	CYoTime cTime;
	if (in_line == 0) m_cArrayFromLine.RemoveAll();
	int in_count = m_cEdit.GetLines();
	for (int i = in_line; i < in_count; i++) {
		TCHAR *wchp_line = m_cEdit.GetLine(i);
		if (wchp_line == NULL) continue;
		if (wchp_line[0] == Cq2chwmEditCtrl::COLOR_FROM ||
			wchp_line[0] == Cq2chwmEditCtrl::COLOR_FROM_WITHMAIL ||
			wchp_line[0] == Cq2chwmEditCtrl::COLOR_FROM_WITHSAGE ||
			wchp_line[0] == Cq2chwmEditCtrl::COLOR_ABONE)
		{
			m_cArrayFromLine.Add(i);
		}
	}
	PRINTLOG("done [%s][%d]%d(msec)", GetArticleId(), m_cArrayFromLine.Count(), cTime.Elapsed());
}

BOOL Cq2chwmDatCtrl::isAboneLine(
	int in_line)
{
	if (m_bo_transparentabone == FALSE) return FALSE;
	TCHAR *wchp_line = m_cEdit.GetLine(in_line);
	return wchp_line[0] == Cq2chwmEditCtrl::COLOR_ABONE;
}

int Cq2chwmDatCtrl::CreateFromHttp()
{
	if (m_bo_running == TRUE) return TRUE;
	m_bo_running = TRUE;
	m_pMain->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)TRUE);

	// infot@Cǂݍ
	if (m_cInfo.Create(GetBoardUrl(), GetArticleId()) == FALSE) {
		m_cInfo.SetNumber(1);
	}

	ResetNewKey();
	int in_ret = Cq2chwmBbsManager::GetInstance()->HttpGet(m_pMain, GetBoardUrl(), GetArticleId(), m_str_err);

	m_bo_running = FALSE;
	m_pMain->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);

	return in_ret;
}

void Cq2chwmDatCtrl::OnCustomMessage(
	Cq2chwmMessage *pMessage)
{
	switch (pMessage->GetType()) {
		case Cq2chwmMessage::TYPE_OPENFILE:
			ULONGLONG ull_length;
			if (ExistFile(pMessage->GetFileName(), &ull_length) == FALSE || ull_length == 0) {
				Clear();
			}
			PRINTLOG("TYPE_OPENFILE: %s:%s(%d)",
				(const char *)m_str_aname, pMessage->GetFileName(), ull_length);
			break;
		case Cq2chwmMessage::TYPE_CLOSEFILE:
		{
			Cq2chwmCloseFileMessage *pCloseFileMessage = (Cq2chwmCloseFileMessage*)pMessage;
			if (pCloseFileMessage->GetWriteSize() > 0) {
				// VtOI
				m_cInfo.SetNew(TRUE);
				m_cInfo.SetCount(GetMessageCount());
				m_cInfo.Write();
			}
			break;
		}
		case Cq2chwmMessage::TYPE_WRITEFILE:
		{
			Cq2chwmWriteFileMessage *pWriteFileMessage = (Cq2chwmWriteFileMessage*)pMessage;
			const char *chp_in = pWriteFileMessage->GetData();
			int in_len = strlen(chp_in);
			PRINTLOG("TYPE_WRITEFILE: %s:%d:%d",
				(const char *)m_str_aname, m_cArrayFromLine.Count(), in_len);

#ifdef UNICODE_CONVERT
			CString cstr_in;
			cstr_in = chp_in;
			CString str_name;
			CString cstr_out;
			int in_out_len = Cq2chwmDatFile::Convert(str_name, cstr_out, cstr_in, m_cArrayFromLine.Count() + 1,
				m_cArrayFromLine.Count() + 1, m_pRegex, m_bo_transparentabone,
				NULL, NULL, &m_cMapId, &m_cMapRefer);
			if (str_name.GetLength() > 0) {
				m_str_aname = A(str_name);
				HtmlToText(m_str_aname);
			}
#else
			char *chp_out = (char*)malloc(sizeof(char) * in_len + CONVERT_BUFFER);
			CYoString str_name;
			int in_out_len = Cq2chwmDatFile::Convert(str_name, chp_out, chp_in, m_cArrayFromLine.Count() + 1,
				m_cArrayFromLine.Count() + 1, m_pRegex, m_bo_transparentabone, Cq2chwmConfig::GetInstance()->GetDeleteBlankLines(),
				NULL, NULL);
			if (str_name.Length() > 0) {
				m_str_aname = str_name;
			}
#endif

			if (m_cArrayFromLine.Count() > 0) m_cEdit.AddText("\r\n", 2);
			m_cEdit.AddText(cstr_out, in_out_len);
			createIndex();
			PRINTLOG("TYPE_WRITEFILE: Added %s:%d:%d",
				(const char *)m_str_aname, m_cArrayFromLine.Count(), in_len);
			break;
		}
		case Cq2chwmMessage::TYPE_RELOADFILE:
			Clear();
			CreateFromFile();
			break;
		case Cq2chwmMessage::TYPE_CLOSETAB:
			break;
	};
}

void Cq2chwmDatCtrl::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if (Cq2chwmConfig::GetInstance()->IsKeyNext(nChar)) {
		if (JumpNextMessage() == FALSE) {
			// ̐VubN}[N
			// ^uő吔1this폜
			// deletẽANZXĂ܂PostMessage
			AfxGetMainWnd()->PostMessage(WM_USER_NEXTARTICLE, 0, (LPARAM)GetFileName());
		}
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPrev(nChar)) {
		JumpPrevMessage();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyNextLine(nChar)) {
		JumpNextLine();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPrevLine(nChar)) {
		JumpPrevLine();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyBottom(nChar)) {
		JumpLastMessage();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyTop(nChar)) {
		JumpFirstMessage();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyNextLink(nChar)) {
		if ((GetKeyState(VK_SHIFT) & 0x8000) == 0) {
			JumpNextLink();
		} else {
			JumpPrevLink();
		}
	} else if (Cq2chwmConfig::GetInstance()->IsKeyPrevLink(nChar)) {
		JumpPrevLink();
	} else if (Cq2chwmConfig::GetInstance()->IsKeyBack(nChar)) {
		JumpBack();
	} else if (nChar == VK_RETURN) {
		Jump();
	}else {
		m_cEdit.OnKeyDown(nChar, nRepCnt, nFlags);
	}

	// {ősێ
	m_in_line_max = max(m_in_line_max, m_cEdit.GetTopLine());
}

void Cq2chwmDatCtrl::JumpNumber(
	int in_number,
	BOOL bo_addhistory)		// cꍇTRUE
{
	PRINTLOG("%d", in_number);
	if (in_number > m_cArrayFromLine.Count()) return;
	if (bo_addhistory == TRUE) m_cArrayJumpHistory.Add(m_cEdit.GetTopLine());
	m_cEdit.SetTopLine((int)m_cArrayFromLine.Get(in_number - 1));
}

void Cq2chwmDatCtrl::JumpUrl(
	const char *chp_url)
{
	PRINTLOG("%s", chp_url);
	// ʃXbhĴ͐eEBhEȂ̂ŐeɃbZ[WM
	// OnKeyDownJumpUrlĂ΂ꂽꍇɃ^uő吔1this폜
	// deletẽANZXĂ܂PostMessage
	m_str_jumpurl = chp_url;
	m_pMain->PostMessage(WM_USER_OPENURL, 0, (LPARAM)(const char*)m_str_jumpurl);
}

#define PAT_URL			"[[h]*t]*tp[s]*://[!-~]+"
#define PAT_NUM			"[>|]*[>|]([0-9O-X]+)"
#define PAT_NUM_NAME	"[\\]][ @]*([0-9O-X]+)[ @]*<"
void Cq2chwmDatCtrl::Jump(
	LPCTSTR lpszLink)
{
	CYoRegex cRegexNum(PAT_NUM, CYoRegex::SJIS);
	CYoRegex cRegexNumName(PAT_NUM_NAME, CYoRegex::SJIS);
	CYoRegex cRegexUrl(PAT_URL, CYoRegex::SJIS);
	CString cstr_text;
	if (lpszLink == NULL) {
		if (m_cEdit.GetSelectedString(cstr_text) == FALSE) {
			return;
		}
	} else {
		cstr_text = lpszLink;
	}

	// I𕶎NƂ݂Ȃ
	CYoString str_text = A(cstr_text);
	if (cRegexNum.Match(str_text) >= 0) {
		m_cArrayJumpHistory.Add(m_cEdit.GetTopLine());
		m_cEdit.SetSelection(0,0,0,0);
		JumpNumber(Atoi(cRegexNum.Get(1)));
		return;
	} else if (cRegexNumName.Match(str_text) >= 0) {
		m_cArrayJumpHistory.Add(m_cEdit.GetTopLine());
		m_cEdit.SetSelection(0,0,0,0);
		JumpNumber(Atoi(cRegexNumName.Get(1)));
		return;
	} else if (cRegexUrl.Match(str_text) >= 0) {
		JumpUrl(cRegexUrl.Get(0));
		return;
	}
}

void Cq2chwmDatCtrl::JumpBack()
{
	int in_count = m_cArrayJumpHistory.Count();
	if (in_count == 0) return;
	int in_line = (int)m_cArrayJumpHistory.Get(in_count - 1);
	m_cArrayJumpHistory.Remove(in_count - 1);
	m_cEdit.SetTopLine(in_line);
}

void Cq2chwmDatCtrl::JumpNextLink()
{
	m_cEdit.SearchNext(PAT_NUM"|"PAT_NUM_NAME"|"PAT_URL);
	return;
}

void Cq2chwmDatCtrl::JumpPrevLink()
{
	m_cEdit.SearchPrev(PAT_NUM"|"PAT_NUM_NAME"|"PAT_URL);
	return;
}

void Cq2chwmDatCtrl::JumpNextLine(
	BOOL bo_link)
{
	if (bo_link == TRUE) {
		if (m_cEdit.SearchNext(PAT_NUM"|"PAT_NUM_NAME"|"PAT_URL, TRUE) == FALSE) {
			m_cEdit.ScrollVertical(TRUE, 1);
		}
	} else {
		m_cEdit.ScrollVertical(TRUE, 1);
	}
	return;
}

void Cq2chwmDatCtrl::JumpPrevLine(
	BOOL bo_link)
{
	if (bo_link == TRUE) {
		if (m_cEdit.SearchPrev(PAT_NUM"|"PAT_NUM_NAME"|"PAT_URL, TRUE) == FALSE) {
			m_cEdit.ScrollVertical(FALSE, 1);
		}
	} else {
		m_cEdit.ScrollVertical(FALSE, 1);
	}
	return;
}

BOOL Cq2chwmDatCtrl::JumpNextMessage()
{
	int in_top = m_cEdit.GetTopLine();
	int in_line = -1;
	for (int i = 0; i < m_cArrayFromLine.Count(); i++) {
		if (in_top < (int)m_cArrayFromLine.Get(i) && isAboneLine((int)m_cArrayFromLine.Get(i)) == FALSE) {
			in_line = (int)m_cArrayFromLine.Get(i);
			break;
		}
	}
	if (in_line == -1) in_line = m_cEdit.GetLines() - 1;
	if (Cq2chwmConfig::GetInstance()->GetNextControl() == TRUE &&
		m_cEdit.IsVisibleLine(in_line) == FALSE)
	{
		// XړŒlɃ`FbNĂĈړ悪ʊOȂy[W_E
		SendMessage(WM_KEYDOWN, VK_NEXT);
		return TRUE;
	} else if (in_line != m_cEdit.GetLines() - 1) {
		m_cEdit.SetTopLine(in_line);
		return TRUE;
	}
	return FALSE;
}

BOOL Cq2chwmDatCtrl::JumpPrevMessage()
{
	int in_top = m_cEdit.GetTopLine();
	int in_line = -1;
	for (int i = m_cArrayFromLine.Count() - 1; i >= 0; i--) {
		if (in_top > (int)m_cArrayFromLine.Get(i) && isAboneLine((int)m_cArrayFromLine.Get(i)) == FALSE) {
			in_line = (int)m_cArrayFromLine.Get(i);
			break;
		}
	}
	if (in_line == -1) {
		return FALSE;
	}
	m_cEdit.SetTopLine(in_line);
	return TRUE;
}

BOOL Cq2chwmDatCtrl::ResetNewKey()
{
	for (int i = 0; i < m_cArrayFromLine.Count(); i++) {
		// Os
		int in_line = (int)m_cArrayFromLine.Get(i);

		// Os΂
		while (m_cEdit.IsLineEnd(in_line) == FALSE) in_line++;
		in_line++;
		TCHAR *chp_tmp = m_cEdit.GetLine(in_line);
		if (chp_tmp == NULL) {
			return FALSE;
		}
		*chp_tmp = Cq2chwmEditCtrl::COLOR_DATE;
	}
	return TRUE;
}

void Cq2chwmDatCtrl::JumpFirstMessage()
{
	m_cArrayJumpHistory.Add(m_cEdit.GetTopLine());
	m_cEdit.SetTopLine((int)m_cArrayFromLine.Get(GetFirstMessageNumber() - 1));
}

void Cq2chwmDatCtrl::JumpLastMessage()
{
	m_cArrayJumpHistory.Add(m_cEdit.GetTopLine());
	m_cEdit.SetTopLine((int)m_cArrayFromLine.Get(GetLastMessageNumber() - 1));

	// {ősێ
	m_in_line_max = max(m_in_line_max, m_cEdit.GetTopLine());
}

int Cq2chwmDatCtrl::GetLastMessageNumber()
{
	int in_no;
	for (in_no = m_cArrayFromLine.Count(); isAboneLine((int)m_cArrayFromLine.Get(in_no - 1)) == TRUE; in_no--) {
		// ځ[񃁃bZ[W͔΂
		;
	}
	return in_no;
}

int Cq2chwmDatCtrl::GetFirstMessageNumber()
{
	int in_no;
	for (in_no = 1; isAboneLine((int)m_cArrayFromLine.Get(in_no - 1)) == TRUE; in_no++) {
		// ځ[񃁃bZ[W͔΂
		;
	}
	return in_no;
}

BOOL Cq2chwmDatCtrl::MoveWindow(
	int x,
	int y,
	int cx,
	int cy)
{
	int in_no = GetCurrentMessageNumber();
	m_cEdit.MoveWindow(x, y, cx, cy);
	if (m_in_width != cx) {
		createIndex();
		m_in_width = cx;
		JumpNumber(in_no);
	}
	return TRUE;
}

int Cq2chwmDatCtrl::GetCurrentMessageNumber()
{
	return GetMessageNumber(m_cEdit.GetTopLine());
}

int Cq2chwmDatCtrl::GetMessageNumber(
	int in_line)
{
	int i = 0;
	for (i = 0; i < m_cArrayFromLine.Count(); i++) {
		if (in_line < (int)m_cArrayFromLine.Get(i)) {
			break;
		}
	}
	return i;
}

void Cq2chwmDatCtrl::GetMessageText(
	int in_number,
	CString& cstr_text,
	BOOL bo_all,			// OAt܂߂ꍇTRUE
	BOOL bo_ext)			// q2chg܂߂ꍇTRUE
{
	int in_first = (int)m_cArrayFromLine.Get(in_number - 1);
	if (bo_all == FALSE) {
		// Os΂
		while (m_cEdit.IsLineEnd(in_first) == FALSE) in_first++;
		in_first++;

		// ts΂
		while (m_cEdit.IsLineEnd(in_first) == FALSE) in_first++;
		in_first++;
	}
	int in_last;
	if (in_number >= m_cArrayFromLine.Count()) {
		in_last = m_cEdit.GetLines();
	} else {
		in_last = (int)m_cArrayFromLine.Get(in_number);
	}

	cstr_text = "";
	for (int i = in_first; i < in_last; i++) {
		CString cstr_line;
		m_cEdit.GetLineString(i, cstr_line, TRUE);
		if (cstr_line.GetAt(0) == Cq2chwmEditCtrl::COLOR_IMAGE) continue;
		if (bo_ext == FALSE && m_cEdit.IsExtChar(cstr_line.GetAt(0))) {
			cstr_text += (const wchar_t*)cstr_line + 1;
		} else {
			cstr_text += cstr_line;
		}
		if (m_cEdit.IsLineEnd(i) == TRUE) cstr_text += "\r\n";
	}
}

void Cq2chwmDatCtrl::GetCurrentMessageText(
	CString& cstr_text,
	BOOL bo_all,			// OAt܂߂ꍇTRUE
	BOOL bo_ext)			// q2chg܂߂ꍇTRUE
{
	return GetMessageText(GetCurrentMessageNumber(), cstr_text, bo_all, bo_ext);
}

void Cq2chwmDatCtrl::Copy()
{
	m_cEdit.Copy();
}

BOOL Cq2chwmDatCtrl::Write(
	BOOL bo_force)
{
	CYoTime cTime;
	BOOL bo_update = bo_force;

	// {ő僁bZ[Wԍ擾
	int in_max_number = GetMessageNumber(m_in_line_max);
	if (in_max_number != m_cInfo.GetMax()) {
		PRINTLOG("max: %d:%d", in_max_number, m_cInfo.GetMax());
		m_cInfo.SetMax(in_max_number);
		bo_update = TRUE;
	}

	// ݃bZ[Wԍ擾
	int in_current_number = GetCurrentMessageNumber();
	if (in_current_number != m_cInfo.GetNumber()) {
		PRINTLOG("num: %d:%d", in_current_number, m_cInfo.GetNumber());
		m_cInfo.SetNumber(in_current_number);
		bo_update = TRUE;
	}

	// Ō̃bZ[Wԍ܂ňړĂVtOIt
	if (m_cInfo.GetNew() == TRUE && in_max_number == GetLastMessageNumber()) {
		PRINTLOG("new");
		m_cInfo.SetNew(FALSE);
		bo_update = TRUE;
	}

	// XV
	if (bo_update == TRUE) {
		if (m_cInfo.Write() == FALSE) {
			PRINTLOG("Cq2chwmInfoFile::Write error: %d", ::GetLastError());
		}
		PRINTLOG("done [%s]%d(msec)", GetArticleId(), cTime.Elapsed());
	}

	return TRUE;
}

void Cq2chwmDatCtrl::Clear()
{
	m_cMapId.RemoveAll();
	m_cMapRefer.RemoveAll();
	m_cArrayFromLine.RemoveAll();
	m_cEdit.Clear();
	m_cImageManager.Destroy();
}

void Cq2chwmDatCtrl::Delete()
{
	Cq2chwmDatFile::Delete(GetBoardUrl(), GetArticleId());
}

void Cq2chwmDatCtrl::SetFont(
	const char *chp_name,
	int in_size,
	BOOL bo_bold)
{
	if (m_str_font_name == chp_name && m_in_font_size == in_size && m_bo_font_bold == bo_bold) return;
	m_cEdit.SetFont(chp_name, in_size, bo_bold);
	createIndex();
	m_str_font_name = chp_name;
	m_in_font_size = in_size;
	m_bo_font_bold = bo_bold;
}

void Cq2chwmDatCtrl::SetWrap(
	BOOL bo_wrap)
{
	if (m_cEdit.GetWrap() == bo_wrap) return;
	int in_no = GetCurrentMessageNumber();
	m_cEdit.SetWrap(bo_wrap);
	createIndex();
	JumpNumber(in_no);
}

BOOL Cq2chwmDatCtrl::GetWrap()
{
	return m_cEdit.GetWrap();
}

void Cq2chwmDatCtrl::SetTransParentAbone(
	BOOL bo_flg)
{
	if (m_bo_transparentabone == bo_flg) return;
	m_bo_transparentabone = bo_flg;
	Reload();
}

BOOL Cq2chwmDatCtrl::GetTransParentAbone()
{
	return m_bo_transparentabone;
}

BOOL Cq2chwmDatCtrl::ShowWindow(
	int in_cmd)
{
	return m_cEdit.ShowWindow(in_cmd);
}

BOOL Cq2chwmDatCtrl::GetSelectedString(
	CString& cstr_text)
{
	if (m_cEdit.GetSelectedString(cstr_text) == FALSE) {
		return FALSE;
	}
	return TRUE;
}

LRESULT Cq2chwmDatCtrl::SendMessage(
	int msg,
	WPARAM wParam,
	LPARAM lParam)
{
	return ::SendMessage(m_cEdit.m_hWnd, msg, wParam, lParam);
}

BOOL Cq2chwmDatCtrl::GetMessageId(
	int in_number,
	CString& cstr_id)
{
	// Os̍sԍ擾
	int in_line = (int)m_cArrayFromLine.Get(in_number - 1);

	// Os΂
	while (m_cEdit.IsLineEnd(in_line) == FALSE) in_line++;
	in_line++;

	// ts̕擾
	CString cstr_line;
	m_cEdit.GetLineString(in_line, cstr_line, FALSE);
	while (m_cEdit.IsLineEnd(in_line) == FALSE) {
		in_line++;
		CString cstr_tmp;
		m_cEdit.GetLineString(in_line, cstr_tmp, FALSE);
		cstr_line += cstr_tmp;
	}

	// ID擾
	int in_start = cstr_line.Find(_T("ID:"));
	if (in_start == -1) return FALSE;
	in_start += 3;

	// pXy[X΂
	while (cstr_line[in_start] == _T(' ')) in_start++;

	int in_end = cstr_line.Find(_T(' '), in_start);
	if (in_end == -1) {
		cstr_id = cstr_line.Mid(in_start);
	} else {
		cstr_id = cstr_line.Mid(in_start, in_end - in_start);
	}
	cstr_id.Trim();
	return TRUE;
}

BOOL Cq2chwmDatCtrl::GetMessageName(
	int in_number,
	CString& cstr_name)
{
	// Os̍sԍ擾
	int in_line = (int)m_cArrayFromLine.Get(in_number - 1);

	// Os̕擾
	CString cstr_line;
	m_cEdit.GetLineString(in_line, cstr_line, FALSE);
	while (m_cEdit.IsLineEnd(in_line) == FALSE) {
		in_line++;
		CString cstr_tmp;
		m_cEdit.GetLineString(in_line, cstr_tmp, FALSE);
		cstr_line += cstr_tmp;
	}

	// O擾
	// TODO: [AhX<ƐO擾ł܂
	int in_start = cstr_line.Find(_T(']'));
	if (in_start == -1) return FALSE;
	in_start++;
	int in_end = cstr_line.ReverseFind(_T('<'));
	if (in_end == -1) return FALSE;
	cstr_name = cstr_line.Mid(in_start, in_end - in_start);
	cstr_name.Trim();
	return TRUE;
}

void Cq2chwmDatCtrl::CopyMessage(
	int in_number)
{
	CString cstr_text;
	GetMessageText(in_number, cstr_text, TRUE, FALSE);
	StringToClipboard(cstr_text);
}

void Cq2chwmDatCtrl::CopyMessageAll()
{
	CString cstr_text;
	for (int i = 1; i < GetLastMessageNumber(); i++) {
		CString cstr_tmp;
		GetMessageText(i, cstr_tmp, TRUE, FALSE);
		cstr_text += cstr_tmp;
	}
	StringToClipboard(cstr_text);
}

#define VISIBLECHAR(c) (c >= 0x20 || c == 0x09 || c == 0x0a || c == 0x0d)
BOOL Cq2chwmDatCtrl::DrawProc(
	HWND hWnd,
	HDC hDC,
	int in_left,
	int in_top,
	RECT *stp_rect,
	const TCHAR *lpszText,
	int in_len,
	BOOL sel,
	const void *vop_user)
{
	if (in_len == 0) {
		return FALSE;
	}

	Cq2chwmDatCtrl *pThis = (Cq2chwmDatCtrl*)vop_user;
	// lpszTexts̐擪Ƃ͌Ȃ̂ōs̐擪܂ňړ
	const TCHAR *lpszLineHead = lpszText;
	while (VISIBLECHAR(*lpszLineHead) == TRUE && *lpszLineHead != TEXT('\r') && *lpszLineHead != TEXT('\n')) {
		lpszLineHead--;
	}

	// CC摜\
	if (*lpszLineHead == Cq2chwmEditCtrl::COLOR_IMAGE) {
		// 摜URLs̐擪|C^擾
		const TCHAR *lpszPrevLineHead = lpszLineHead;
		int in_line = -1;
		do {
			in_line++;
			lpszPrevLineHead -= 2;
			while (VISIBLECHAR(*(lpszPrevLineHead - 1)) == TRUE && *(lpszPrevLineHead - 1) != TEXT('\r') && *(lpszPrevLineHead - 1) != TEXT('\n')) {
				lpszPrevLineHead--;
			}
		} while (*(lpszPrevLineHead - 1) == Cq2chwmEditCtrl::COLOR_IMAGE);

		// 摜URL擾
		int in_start = 0;
		int in_x = 0;
		TCHAR *lpszTmp = (TCHAR*)lpszLineHead;
		*lpszTmp = 0x00;
		CString cstr_filename;
		for (int i = 0; pThis->searchUrl(cstr_filename, lpszPrevLineHead, i) == TRUE; i++) {
			Cq2chwmImage *pImage = NULL;
			if (Cq2chwmCacheImageFile::GetInstance()->ExistsItem(cstr_filename) == TRUE) {
				// TlC摜쐬
				RECT rect;
				::GetClientRect(hWnd, &rect);
				pImage = pThis->m_cImageManager.Create(cstr_filename, rect.right, stp_rect->bottom * Cq2chwmConfig::GetInstance()->GetInlineImageHeight(), hDC);
			}

			// `
			if (pImage != NULL) {
				CDC cMemoryDC;
				cMemoryDC.CreateCompatibleDC(CDC::FromHandle(hDC));
				HGDIOBJ hOldBitmap = cMemoryDC.SelectObject(pImage->GetBitmap());
				::BitBlt(hDC, in_x, 0, pImage->GetWidth(), stp_rect->bottom - stp_rect->top, cMemoryDC.m_hDC, 0, (stp_rect->bottom - stp_rect->top) * in_line, SRCCOPY);
				in_x += pImage->GetWidth() + 2;
				cMemoryDC.SelectObject(hOldBitmap);
				cMemoryDC.DeleteDC();
			} else {
				if (in_line == 0) {
					int in_height = stp_rect->bottom - stp_rect->top;
					int in_width = in_height;
					::DrawIconEx(hDC, in_x, 0, pThis->m_hIconImage, in_width, in_height, 0, NULL, DI_NORMAL);
					in_x += in_width + 2;
				}
			}
		}
		*lpszTmp = Cq2chwmEditCtrl::COLOR_IMAGE;
		return TRUE;
	}

	if (sel == TRUE) {
		return FALSE;
	}

	// s̐Fw擾
	BOOL bo_from = FALSE;
	BOOL bo_date = FALSE;
	{
		COLORREF cols[] = {
			Cq2chwmConfig::GetInstance()->GetColorFrom(),
			Cq2chwmConfig::GetInstance()->GetColorFromWithMail(),
			Cq2chwmConfig::GetInstance()->GetColorFromWithSage(),
			Cq2chwmConfig::GetInstance()->GetColorDateNew(),
			Cq2chwmConfig::GetInstance()->GetColorDate(),
			Cq2chwmConfig::GetInstance()->GetColorLink(),
			Cq2chwmConfig::GetInstance()->GetColorAbone(),
			Cq2chwmConfig::GetInstance()->GetColorMessage()
		};
		if (*lpszLineHead >= 0x01 && *lpszLineHead <= 0x08) {
			if (sel == FALSE) {
				COLORREF color = cols[*lpszLineHead - 1];
				::SetTextColor(hDC, color);
			}
			if (*lpszLineHead == Cq2chwmEditCtrl::COLOR_FROM ||
				*lpszLineHead == Cq2chwmEditCtrl::COLOR_FROM_WITHMAIL ||
				*lpszLineHead == Cq2chwmEditCtrl::COLOR_FROM_WITHSAGE ||
				*lpszLineHead == Cq2chwmEditCtrl::COLOR_ABONE)
			{
				bo_from = TRUE;
			} else if (*lpszLineHead == Cq2chwmEditCtrl::COLOR_DATE ||
				*lpszLineHead == Cq2chwmEditCtrl::COLOR_NEW)
			{
				bo_date = TRUE;
			}
		} else if (*(lpszLineHead + 1) == _T('>') || *(lpszLineHead + 1) == _T('')) {
			// p
			const TCHAR *lpszTemp = lpszLineHead + 1;
			while (*lpszTemp == _T('>') || *lpszTemp == _T('')) lpszTemp++;
			if (*lpszTemp >= _T('0') && *lpszTemp <= _T('9') || *lpszTemp >= _T('O') && *lpszTemp <= _T('X')) {
				// >̂ƐȂFtȂ
				::SetTextColor(hDC, Cq2chwmConfig::GetInstance()->GetColorFore());
			} else {
				::SetTextColor(hDC, Cq2chwmConfig::GetInstance()->GetColorCite());
			}
		} else {
			::SetTextColor(hDC, Cq2chwmConfig::GetInstance()->GetColorFore());
		}
	}

	::ExtTextOut(hDC, in_left, in_top, 0, stp_rect, lpszText, in_len, NULL);

	// Ft
	if (bo_from == TRUE) {
		// XԍFt
		TCHAR szBuff[32];
		DWORD dwSize = sizeof(szBuff) / sizeof(szBuff[0]);
		const wchar_t *lpszTemp = GetNumber(szBuff, &dwSize, lpszLineHead + 1);
		if (lpszTemp != NULL && lpszTemp + dwSize >= lpszText && lpszTemp < lpszText + in_len) {
			void *vop_count;
			if (pThis->m_cMapRefer.Lookup(szBuff, vop_count) == TRUE && (int)vop_count > 0) {
				SIZE sz = {0};
				int in_move = 0;
				if (lpszTemp > lpszText) {
					// `Ώە̓rɃXԍ݂P[X
					CString cstr_left;
					cstr_left.SetString(lpszText, lpszTemp - lpszText);
					::GetTextExtentPoint32(hDC, cstr_left, cstr_left.GetLength(), &sz);
				} else if (lpszTemp < lpszText) {
					// `Ώە񂪃Xԍ̓rn܂P[X
					in_move = lpszText - lpszTemp;
				}
				COLORREF color_old = ::GetTextColor(hDC);
				::SetTextColor(hDC, Cq2chwmConfig::GetInstance()->GetColorLink());
				::ExtTextOut(hDC, in_left + sz.cx, in_top, 0, stp_rect, szBuff + in_move, dwSize - in_move, NULL);
				::SetTextColor(hDC, color_old);
			}
		}
	} else if (bo_date == TRUE) {
		// IDFt
		TCHAR szId[256];
		DWORD dwSize = sizeof(szId) / sizeof(szId[0]);
		const wchar_t *lpszTemp = GetId(szId, &dwSize, lpszLineHead + 1);
		if (lpszTemp != NULL && lpszTemp + dwSize >= lpszText && lpszTemp < lpszText + in_len) {
			void *vop_count;
			if (pThis->m_cMapId.Lookup(szId, vop_count) == TRUE && (int)vop_count > 1) {
				SIZE sz = {0};
				int in_move = 0;
				if (lpszTemp > lpszText) {
					// `Ώە̓rID݂P[X
					CString cstr_left;
					cstr_left.SetString(lpszText, lpszTemp - lpszText);
					::GetTextExtentPoint32(hDC, cstr_left, cstr_left.GetLength(), &sz);
				} else if (lpszTemp < lpszText) {
					// `ΏەID̓rn܂P[X
					in_move = lpszText - lpszTemp;
				}
				COLORREF color_old = ::GetTextColor(hDC);
				::SetTextColor(hDC, Cq2chwmConfig::GetInstance()->GetColorLink());
				::ExtTextOut(hDC, in_left + sz.cx, in_top, 0, stp_rect, szId + in_move, dwSize - in_move, NULL);
				::SetTextColor(hDC, color_old);
			}
		}
	} else {
		// NFt
		const wchar_t *lpszTemp = lpszLineHead + 1;
		while (1) {
			TCHAR szLink[8192];
			DWORD dwSize = sizeof(szLink) / sizeof(szLink[0]);
			lpszTemp = GetLink(szLink, &dwSize, lpszTemp);
			if (lpszTemp == NULL) break;
			if (lpszTemp + dwSize >= lpszText && lpszTemp < lpszText + in_len) {
				// `Ώە̒ɍ킹
				szLink[lpszText + in_len - lpszTemp] = 0;
				SIZE sz = {0};
				int in_move = 0;
				if (lpszTemp > lpszText) {
					// `Ώە̓rɃN񂪑݂P[X
					CString cstr_left;
					cstr_left.SetString(lpszText, lpszTemp - lpszText);
					::GetTextExtentPoint32(hDC, cstr_left, cstr_left.GetLength(), &sz);
				} else if (lpszTemp < lpszText) {
					// `Ώە񂪃N̓rn܂P[X
					in_move = lpszText - lpszTemp;
				}
				COLORREF color_old = ::GetTextColor(hDC);
				::SetTextColor(hDC, Cq2chwmConfig::GetInstance()->GetColorLink());
				::ExtTextOut(hDC, in_left + sz.cx, in_top, 0, stp_rect, szLink + in_move, _tcslen(szLink) - in_move, NULL);
				::SetTextColor(hDC, color_old);
			}
			lpszTemp += dwSize;
		}
	}

	return TRUE;
}

BOOL Cq2chwmDatCtrl::GetColorProc(
	int in_id,
	COLORREF *color,
	const void *vop_user)
{
	if (color == NULL || vop_user == NULL) return FALSE;
	Cq2chwmDatCtrl *pThis = (Cq2chwmDatCtrl*)vop_user;
	switch (in_id) {
	case COLOR_FORE:
		*color = Cq2chwmConfig::GetInstance()->GetColorFore();
		break;
	case COLOR_BACK:
		*color = Cq2chwmConfig::GetInstance()->GetColorBack();
		break;
	default:
		return FALSE;
	}

	return TRUE;
}

BOOL Cq2chwmDatCtrl::BeforeWindowProc(
	HWND hWnd,
	UINT msg,
	WPARAM wParam,
	LPARAM lParam,
	const void *vop_user)
{
	Cq2chwmDatCtrl *pThis = (Cq2chwmDatCtrl*)vop_user;
	if (msg == WM_KEYDOWN) {
		// nEditɑꂽL[CxgDatViewŏ
		Cq2chwmDatCtrl *pThis = (Cq2chwmDatCtrl*)vop_user;
		pThis->m_pParent->SendMessage(msg, wParam, lParam);

		// TRUEԂnEditŏsȂ
		return TRUE;
	}
	return FALSE;
}

BOOL Cq2chwmDatCtrl::AfterWindowProc(
	HWND hWnd,
	UINT msg,
	WPARAM wParam,
	LPARAM lParam,
	const void *vop_user)
{
	Cq2chwmDatCtrl *pThis = (Cq2chwmDatCtrl*)vop_user;
	if (msg == WM_LBUTTONUP) {
		// NbNCxg
		return pThis->OnLButtonUp(wParam, lParam);
	}
	return FALSE;
}

BOOL Cq2chwmDatCtrl::OnLButtonUp(
	WPARAM wParam,
	LPARAM lParam)
{
	// J[\ʒu擾
	int in_row_s, in_row_e, in_col_s, in_col_e;
	m_cEdit.GetSelection(in_row_s, in_row_e, in_col_s, in_col_e);
	if (in_row_s != in_row_e || in_col_s != in_col_e) {
		// I𕶎񂪑݂ȂNbNƂ݂ȂȂ
		return FALSE;
	}

	// J[\ʒus̏I[Ȃ當NbNƔfȂ
	if (m_cEdit.GetLineLength(in_row_s) <= in_col_s) {
		return FALSE;
	}

	// NbNʒu̕|C^߂
	TCHAR *lpszLineHead = m_cEdit.GetLine(in_row_s);
	if (lpszLineHead == NULL) {
		return FALSE;
	}

	// O㕶񂩂烊N𐶐
	TCHAR *lpszTemp = lpszLineHead + in_col_s;
	TCHAR *lpszStart = lpszTemp;
	while ((*(lpszStart - 1) >= _T('!') && *(lpszStart - 1) <= _T('~')) ||
		*(lpszStart - 1) == _T('') ||
		(*(lpszStart - 1) >= _T('O') && *(lpszStart - 1) <= _T('X')))
	{
		lpszStart--;
	}

	TCHAR *lpszEnd = lpszTemp;
	while ((*lpszEnd >= _T('!') && *lpszEnd <= _T('~')) ||
		*lpszEnd - 1 == _T('') ||
		(*lpszEnd >= _T('O') && *lpszEnd <= _T('X')))
	{
		lpszEnd++;
	}

	CString cstr_link;
	if (lpszEnd - lpszStart > 0) {
		cstr_link.SetString(lpszStart, lpszEnd - lpszStart);
	}

	if (*lpszLineHead == Cq2chwmEditCtrl::COLOR_FROM ||
		*lpszLineHead == Cq2chwmEditCtrl::COLOR_FROM_WITHMAIL ||
		*lpszLineHead == Cq2chwmEditCtrl::COLOR_FROM_WITHSAGE ||
		*lpszLineHead == Cq2chwmEditCtrl::COLOR_ABONE)
	{
		if (in_col_s > 0 && cstr_link.Find(_T(']')) > in_col_s) {
			// Xԍ
			TCHAR szBuff[32] = {0};
			DWORD dwSize = sizeof(szBuff) / sizeof(szBuff[0]);
			if (GetNumber(szBuff, &dwSize, cstr_link) != NULL) {
				void *vop_count;
				if (m_cMapRefer.Lookup(szBuff, vop_count) == TRUE && (int)vop_count > 0) {
					GrepRefer(_wtoi(szBuff));
				}
			}
		}
	} else if (*lpszLineHead == Cq2chwmEditCtrl::COLOR_DATE ||
		*lpszLineHead == Cq2chwmEditCtrl::COLOR_NEW)
	{
		// ID
		TCHAR szBuff[256] = {0};
		DWORD dwSize = sizeof(szBuff) / sizeof(szBuff[0]);
		if (GetId(szBuff, &dwSize, cstr_link) == NULL) {
			// ΂́uID:v̂ƂɃXy[X邽cstr_linkɁuID:v܂܂ꂸGetIdNULLԂĂ܂
			_tcscpy_s(szBuff, dwSize, cstr_link);
		}
		if (szBuff[0] != 0) {
			void *vop_count;
			if (m_cMapId.Lookup(szBuff, vop_count) == TRUE && (int)vop_count > 1) {
				GrepId(szBuff);
			}
		}
	} else {
		Jump(cstr_link);
	}

	return TRUE;
}

BOOL Cq2chwmDatCtrl::GrepRefer(
	int in_number)
{
	// 񐶐
	CYoString str_zennum = ConvertZenkaku(in_number);
	CYoString str_hannum = in_number;
	CYoString str_pat = "(>|)";
	for (int i = 0; i < str_hannum.Length(); i++) {
		CYoString str_han = str_hannum.Mid(i, 1);
		CYoString str_zen = str_zennum.Mid(i * 2, 2);
		str_pat.FormatAdd("(%s|%s)", (const char*)str_han, (const char*)str_zen);
	}
	str_pat += "[^0-9|O-X]";

	// K\쐬
	CString cstr_pat;
	cstr_pat = str_pat;
	CYoRegex cRegex(cstr_pat, CYoRegex::UTF16LE);

	// o_CAÕWvj[̂߂ɒobZ[W̃XԍێĂ
	CYoPtrArray cArray;

	// o
	CString cstr_message;
	int in_last = GetLastMessageNumber();
	for (int i = 1; i <= in_last; i++) {
		CString cstr_tmp;
		GetMessageText(i, cstr_tmp, TRUE, TRUE);
		if (cRegex.Match((const wchar_t*)cstr_tmp) >= 0) {
			cstr_message += cstr_tmp;
			cArray.Add(i);
		}
	}

	if (cstr_message.GetLength() > 0) {
		Cq2chwmGrepDialog cDialog;
		cDialog.SetText(cstr_message);
		if (cDialog.DoModal() == IDOK) {
			// Wv
			JumpNumber((int)cArray.Get(cDialog.GetJumpNumber() - 1));
		}
	}
	return TRUE;
}

BOOL Cq2chwmDatCtrl::GrepId(
	LPCTSTR lpszId)
{
	// oEBhẼWvj[̂߂ɒobZ[W̃XԍێĂ
	CYoPtrArray cArray;

	// bZ[W1IDA}b`烁bZ[WRs[
	CString cstr_message;
	int in_last = GetLastMessageNumber();
	for (int i = 1; i <= in_last; i++) {
		CString cstr_id;
		if (GetMessageId(i, cstr_id) == TRUE && cstr_id == lpszId) {
			CString cstr_tmp;
			GetMessageText(i, cstr_tmp, TRUE, TRUE);
			cstr_message += cstr_tmp;
			cArray.Add(i);
		}
	}

	if (cstr_message.GetLength() > 0) {
		Cq2chwmGrepDialog cDialog;
		cDialog.SetText(cstr_message);
		if (cDialog.DoModal() == IDOK) {
			// Wv
			JumpNumber((int)cArray.Get(cDialog.GetJumpNumber() - 1));
		}
	}
	return TRUE;
}

BOOL Cq2chwmDatCtrl::GrepName(
	LPCTSTR lpszName)
{
	// oEBhẼWvj[̂߂ɒobZ[W̃XԍێĂ
	CYoPtrArray cArray;

	// bZ[W1疼OA}b`烁bZ[WRs[
	CString cstr_message;
	int in_last = GetLastMessageNumber();
	for (int i = 1; i <= in_last; i++) {
		CString cstr_name;
		if (GetMessageName(i, cstr_name) == TRUE && cstr_name == lpszName) {
			CString cstr_tmp;
			GetMessageText(i, cstr_tmp, TRUE, TRUE);
			cstr_message += cstr_tmp;
			cArray.Add(i);
		}
	}

	if (cstr_message.GetLength() > 0) {
		Cq2chwmGrepDialog cDialog;
		cDialog.SetText(cstr_message);
		if (cDialog.DoModal() == IDOK) {
			// Wv
			JumpNumber((int)cArray.Get(cDialog.GetJumpNumber() - 1));
		}
	}
	return TRUE;
}

/*!
 * \brief
 * s̐擪|C^摜URLAt@CpX擾.
 * 
 * \param cstr_filename
 * 摜t@CpX̏ݐ.
 * 
 * \param lpszLine
 * s̐擪|C^.
 * 
 * \param in_index
 * ̉摜URL݂ꍇ̃CfbNX.
 * 
 * \returns
 * ITRUEAُICfbNXɑ΂摜URL݂ȂꍇFALSE.
 * 
 * CCTlCgpATlC摜TCY̐K\sȂ悤ɂ邽߁A
 * 摜URLsɊ܂܂t@CpXLbVĂdg݂.
 */
BOOL Cq2chwmDatCtrl::searchUrl(
	CString &cstr_filename,
	const TCHAR *lpszLine,
	int in_index)
{
	if (lpszLine == NULL) return FALSE;
	if (m_lpszLine != lpszLine) {
		// OsK\̑ΏۍsłȂꍇ́AK\
		// ׂẲ摜URL擾Azɒǉ
		m_lpszLine = lpszLine;
		m_cImageFileArray.RemoveAll();
		int in_start = 0;
		int in_ret;
		while ((in_ret = m_cRegexImage.Match(lpszLine + in_start)) >= 0) {
			// 摜URLt@CpX
			const TCHAR *lpszUrl = (const wchar_t*)m_cRegexImage.Get(1);
			CString cstr_tmp;
			cstr_tmp = UrlToImagePath(A(lpszUrl));
			m_cImageFileArray.Add(cstr_tmp);

			// ̉摜URL
			in_start += (in_ret / 2) + _tcslen(lpszUrl);
		}
	}

	if (m_cImageFileArray.GetCount() <= in_index) {
		return FALSE;
	}

	cstr_filename = m_cImageFileArray.GetAt(in_index);
	return TRUE;
}
