//---------------------------------------------------------------------------
//  Controled-not gate
//---------------------------------------------------------------------------
#include "QC_cnot.h"
//---------------------------------------------------------------------------
/**
 *  Constructor
 */
QC_cnot::QC_cnot(int _TargetBit,int _ControlBit) : QCalcUnit() {
    TargetBit  = _TargetBit;
    ControlBit = _ControlBit;
}
//---------------------------------------------------------------------------
/**
 *  Calculation
 */
void QC_cnot::calc(int Target, int Control,
                   double BitsR[], double BitsI[], int NumberOfBits) {
    unsigned int states = (1 << (NumberOfBits - 2));

    // Sort BitsNumber to regular order
    int Bit0 = Target;
    int Bit1 = Control;
    if (Bit0 > Bit1) {
        swap(Bit0, Bit1);
    }

    for (unsigned int i = 0; i < states; i++) {
        unsigned int ix1 = QCalcUnit::insert1(i,   Bit0);
        ix1 = QCalcUnit::insert1(ix1, Bit1);
        unsigned int ix0 = ix1 & ~(1 << Target);

        swap(BitsR[ix0], BitsR[ix1]);
        swap(BitsI[ix0], BitsI[ix1]);
    }
}
//---------------------------------------------------------------------------
void
QC_cnot::Calc(QBits *qBits) {
    int N = qBits->GetNumberOfQBits();
    double *R = qBits->GetBitsR();//Real Part
    double *I = qBits->GetBitsI();//Imaginary Part

    QC_cnot::calc(TargetBit, ControlBit, R, I, N);
}
//---------------------------------------------------------------------------
#ifdef __USE__MPI
void
QC_cnot::calcmpi(int t1, int c1, double R[], double I[], int N) {
    double r0 = 0.0;
    double i0 = 0.0;
    double r1 = 0.0;
    double i1 = 0.0;
    unsigned int ix0, ix1;

    // Sort BitsNumber to regular order
    int Bit0 = t1;
    int Bit1 = c1;
    if (Bit0 > Bit1) {
        swap(Bit0, Bit1);
    }

    for (int i = 0; i < (1 << (N - 2)); i++) {
        // Obtain indices of state:
        unsigned int ix1 = QCalcUnit::insert1(i,   Bit0);
        ix1 = QCalcUnit::insert1(ix1, Bit1);
        unsigned int ix0 = ix1 & ~(1 << t1);

        bool bstore = setup(R, I, ix0, ix1, r0, i0, r1, i1);
        if (bstore) {
            swap(r0, r1);
            swap(i0, i1);
            // Store:
            store(R, I, ix0, ix1, r0, i0, r1, i1);
        }
    }
}
#endif
//---------------------------------------------------------------------------
