//---------------------------------------------------------------------------
#ifndef QRotH
#define QRotH
//---------------------------------------------------------------------------
#include "QCircuit.h"
//---------------------------------------------------------------------------
class QRot : public QCircuit {
private:

  double Phase; // Angle (Degree)

public:
  QRot(int x,int y);
  QRot(int x,int y, string Param);

  virtual int GetType(void)    { return QC_ROT; }
  virtual string GetTypeStr(void) { return "QRot"; }

  string GetCalcText(void);

  void Draw(QDraw *Draw);
  void DrawPS(QPSDraw *psDraw);
  string GetParam(void);
  void Reverse(int y);
  TRect GetOccupiedRect();
  QCircuit *Clone();
  double GetPhase(void){
    return Phase;
  };
  void SetPhase(double p){
    Phase = p;
  };
};
//---------------------------------------------------------------------------

#endif
