//---------------------------------------------------------------------------
// Hadamard Gate
//---------------------------------------------------------------------------
#include "QWalsh.h"
//---------------------------------------------------------------------------
QWalsh::QWalsh(int x,int y) :QCircuit(x,y) {
  Name = GetTypeStr();
}
//---------------------------------------------------------------------------
void
QWalsh::Draw(QDraw *qDraw) {
  int GridSize = qDraw->GetGridSize();
  int UnitSize = qDraw->GetUnitSize();
  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  qDraw->SetBrushColor(clWhite);
  qDraw->FillRect(x1,y1,x2,y2);
  qDraw->SetBrushColor(clRed);
  qDraw->FrameRect(x1,y1,x2,y2);

  qDraw->SetBrushColor(clWhite);
  qDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2,"H");
}
//---------------------------------------------------------------------------
string
QWalsh::GetCalcText(void) {
  ostringstream os;
  os << "H(q[" << Y << "])";
  return os.str();
}
//---------------------------------------------------------------------------
void
QWalsh::DrawPS(QPSDraw *psDraw) {
  int GridSize = psDraw->GetGridSize();
  int UnitSize = psDraw->GetUnitSize();
  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  psDraw->FillRect(x1,y1,x2,y2);
  psDraw->FrameRect(x1,y1,x2,y2);
  psDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2,"H");
}
//---------------------------------------------------------------------------
void
QWalsh::Reverse(int y) {
  Y = y - Y;
}
//---------------------------------------------------------------------------
TRect
QWalsh::GetOccupiedRect() {
  return TRect(X, Y, X + 1, Y + 1);
}
//---------------------------------------------------------------------------
QCircuit *
QWalsh::Clone() {
  QWalsh *qw = new QWalsh(X, Y);
  return (QCircuit*)qw;
}
//---------------------------------------------------------------------------

