//----------------------------------------------------------------------------
//  Compile intermediates into list of the calc units
//----------------------------------------------------------------------------
#ifndef QCOMPILERCNTL_H
#define QCOMPILERCNTL_H

#include <iostream>
#include <vector>
#include "QCompiler.h"
#include "QParseInfo.h"
#include "QCalcUnit.h"

class QCompilerCntl : public QCompiler {
protected:
  int mNumOfQBits;

public:
  QCompilerCntl(void);
  QCompilerCntl(std::istream &is);
  virtual ~QCompilerCntl();
  int GetNumberOfControl(void) {
    return mQParseInfo.size();
  }
  QCalcUnit *AllocateControl(const unsigned int index);
  void Clear(void) {
    mQParseInfo.clear();
  }
  int GetNumberOfQBits(void) {
    return mNumOfQBits;
  }

protected:
  std::vector<QParseInfo> mQParseInfo;
  virtual bool CompileOneLine(const QParseInfo &pinfo);
  virtual void CatchError(const QParseInfo &pinfo, const int at);
};

#endif //QCOMPILERCNTL_H
