//---------------------------------------------------------------------------
#ifndef GraphH
#define GraphH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
#include "QDrawGraph.h"
#include "QDrawHSVGraph.h"
#include <ComCtrls.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
class TFGraph : public TForm {
__published:
  TPageControl *PageControl;
  TTabSheet *TSStandard;
  TTabSheet *TSHsv;
  TImage *ImageHsv;
  TTabSheet *TSHsv2D;
  TImage *ImageHsv2D;
  TMainMenu *MainMenu1;
  TMenuItem *File1;
  TMenuItem *MMSaveResults;
  TMenuItem *N1;
  TMenuItem *MMClose;
  TSaveDialog *SaveDialog;
  TTabSheet *TSMeasured;
  TRichEdit *REMeasured;
  TPaintBox *PaintBox;
  TScrollBar *SBarStandard;
  TGroupBox *GroupBox1;
  TRadioButton *RBShowAll;
  TRadioButton *RBShowNonZero;
  TMenuItem *Edit1;
  TMenuItem *MMCopy;
  TPopupMenu *PMMeasured;
  TMenuItem *PMCopy;
        TMenuItem *MMHide;
  void __fastcall FormMouseWheel(TObject *Sender, TShiftState Shift,
                                 int WheelDelta, TPoint &MousePos, bool &Handled);
  void __fastcall MMSaveResultsClick(TObject *Sender);
  void __fastcall MMCloseClick(TObject *Sender);
  void __fastcall RBShowNonZeroClick(TObject *Sender);
  void __fastcall RBShowAllClick(TObject *Sender);
  void __fastcall PaintBoxPaint(TObject *Sender);
  void __fastcall SBarStandardScroll(TObject *Sender,
                                     TScrollCode ScrollCode, int &ScrollPos);
  void __fastcall FormResize(TObject *Sender);
  void __fastcall FormDestroy(TObject *Sender);
  void __fastcall MMCopyClick(TObject *Sender);
  void __fastcall PMCopyClick(TObject *Sender);
        void __fastcall MMHideClick(TObject *Sender);
private:
  QDrawGraph *qDrawGraph;
  QDrawHSVGraph *qDrawHsvGraph;

  void ShowAll(void);
public:

  QBits *qBits; //Stored Data

  void ShowMeasurement(void);

  void Execute(QBits *qBits);

  __fastcall TFGraph(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TFGraph *FGraph;
//---------------------------------------------------------------------------
#endif
