//---------------------------------------------------------------------------
// PostScript
//---------------------------------------------------------------------------
#include <iostream>
#include <string>
#include <sstream>
#include "QPSDraw.h"
using namespace std;
//---------------------------------------------------------------------------
QPSDraw::QPSDraw(void) : QAbstractDraw() {
  FontSize = 14*0.8;
  Width = 0;
  Height = 0;
}
//---------------------------------------------------------------------------
QPSDraw::~QPSDraw(void) {}
//---------------------------------------------------------------------------
void
QPSDraw::AddText(const char *str) {
  osEPS << str << endl;
}
//---------------------------------------------------------------------------
string
QPSDraw::GetText(void) {

  ostringstream os;
  os << "%!PS-Adobe-2.0" << endl;
  os << "%%Title: QCAD" << endl;
  os << "%%Creator: QCAD(kaityo)" << endl;
  os << "%%BoundingBox: 0 0 " << Width+LeftMargin << " " << Height+TopMargin << endl;
  os << "%%Orientation: Portrait" << endl;
  os << "%%Pages: 1" << endl;
  os << "%%Page: 1 1" << endl;

  os << "/G " << GridSize << " def" << endl;
  os << "/U " << UnitSize << " def" << endl;
  os << "/UH " << UnitSize/2 << " def" << endl;

  os << "/M { gsave translate newpath 0 0 UH 0 180 arc closepath 0 0 moveto UH UH lineto stroke grestore } def" << endl;

  os << "/mydict 120 dict def" << endl;
  os << "mydict begin" << endl;
  os << "gsave" << endl;
  os << LeftMargin << " " << TopMargin << " translate" << endl;

  os << "/Helvetica findfont 14 scalefont setfont" << endl;

  os << osEPS.str() << endl;

  os << "stroke" << endl;
  os << "showpage" << endl;
  return os.str();
}
//---------------------------------------------------------------------------
// Drawing Method
//---------------------------------------------------------------------------
void
QPSDraw::DrawLine(int x1,int y1,int x2,int y2) {

  ostringstream os;
  os << x1 << " " << y1 << " moveto ";
  os << x2 << " " << y2 << " lineto stroke";
  AddText(os.str().c_str());
}
//---------------------------------------------------------------------------
void
QPSDraw::DrawDashedLine(int x1,int y1,int x2,int y2) {
  AddText("[3] 0 setdash");
  DrawLine(x1,y1,x2,y2);
  AddText("[] 0 setdash");
}
//---------------------------------------------------------------------------
void
QPSDraw::TextOut(int x1,int y1,string text) {

  x1-=FontSize/2*text.length();
  y1-=FontSize/2;

  ostringstream os;
  os << x1 << " " << y1 << " moveto ";
  os << "(" << text << ") show ";
  AddText(os.str().c_str());
}
//---------------------------------------------------------------------------
void
QPSDraw::FrameRect(int x1, int y1, int x2, int y2) {

  ostringstream os;
  os << "newpath" << endl;
  os << x1 << " " << y1 << " moveto" << endl;
  os << x1 << " " << y2 << " lineto" << endl;
  os << x2 << " " << y2 << " lineto" << endl;
  os << x2 << " " << y1 << " lineto" << endl;
  os << "closepath stroke" << endl;
  AddText(os.str().c_str());

}
//---------------------------------------------------------------------------
void
QPSDraw::FillRect(int x1, int y1, int x2, int y2) {
  ostringstream os;

  os << "newpath" << endl;
  os << x1 << " " << y1 << " moveto" << endl;
  os << x1 << " " << y2 << " lineto" << endl;
  os << x2 << " " << y2 << " lineto" << endl;
  os << x2 << " " << y1 << " lineto" << endl;
  os << "closepath 1 setgray fill stroke 0 setgray" << endl;
  AddText(os.str().c_str());
}
//---------------------------------------------------------------------------
void
QPSDraw::DrawCircle(int x1,int y1,int r) {

  ostringstream os;
  os << "newpath" << endl;
  os << x1 << " " << y1 << " " << r << " 0 360 arc closepath stroke" << endl;
  AddText(os.str().c_str());
}
//---------------------------------------------------------------------------
void
QPSDraw::DrawFillCircle(int x1,int y1,int r) {

  ostringstream os;
  os << "newpath" << endl;
  os << x1 << " " << y1 << " " << r << " 0 360 arc fill closepath stroke" << endl;
  AddText(os.str().c_str());
}
//---------------------------------------------------------------------------
void
QPSDraw::DrawMeasure(int x1,int y1) {
  ostringstream os;
  os << x1 << " " << y1 << " M" << endl;
  AddText(os.str().c_str());
}
//---------------------------------------------------------------------------
void
QPSDraw::DrawGrid(int line, bool enabled) {
  if (!enabled) {
    int x1 = Width/2;
    int y1 = line*GridSize;
    int x2 = x1;
    int y2 = y1+GridSize;
    DrawDashedLine(x1,y1,x2,y2);
  } else {
    DrawLine(0,line*GridSize+GridSize/2,Width,line*GridSize+GridSize/2);
  }
}
//---------------------------------------------------------------------------

