/*
 *  qcunitcalc.h
 *  $Date: $
 *  $Revision: $
 */

#ifndef QCUNITCALC_H
#define QCUNITCALC_H

namespace qc {
//----------------------------------------------------------------------------
inline unsigned int insert0(const unsigned int i0, const unsigned int bitnum)
{
    unsigned int msk = (1 << bitnum) - 1;
    return ((~msk & i0) << 1) | (msk & i0);
}

inline unsigned int insert1(const unsigned int i0, const unsigned int bitnum)
{
    unsigned int msk = (1 << bitnum) - 1;
    return ((~msk & i0) << 1) | (1 << bitnum) | (msk & i0);
}

template <class T>
inline void swap(T &x, T &y)
{
    T   tmp = x;
        x   = y;
        y   = tmp;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
inline void qcuc_ccnot(double &r0, double &i0, double &r1, double &i1)
{
    swap(r0, r1);
    swap(i0, i1);
}

//----------------------------------------------------------------------------
inline void qcuc_cnot(double &r0, double &i0, double &r1, double &i1)
{
    swap(r0, r1);
    swap(i0, i1);
}

//----------------------------------------------------------------------------
inline void qcuc_crot(double &r0, double &i0, double c, double s)
{
    double r1   = r0;
    double i1   = i0;
    r0 = c * r1 - s * i1;
    i0 = c * i1 + s * r1;
}

//----------------------------------------------------------------------------
inline void qcuc_hadamard(double &r0, double &i0, double &r1, double &i1)
{
    const double isq2 = 0.70710678118654752440084436210485;
    double rr0 = r0;
    double ii0 = i0;
    double rr1 = r1;
    double ii1 = i1;
    r0 = isq2 * (  rr1 + rr0);
    i0 = isq2 * (  ii1 + ii0);
    r1 = isq2 * (- rr1 + rr0);
    i1 = isq2 * (- ii1 + ii0);
}

//----------------------------------------------------------------------------
inline void qcuc_not(double &r0, double &i0, double &r1, double &i1)
{
    swap(r0, r1);
    swap(i0, i1);
}

//----------------------------------------------------------------------------
inline void qcuc_pauli_x(double &r0, double &i0, double &r1, double &i1)
{
    swap(r0, r1);
    swap(i0, i1);
}

//----------------------------------------------------------------------------
inline void qcuc_pauli_y(double &r0, double &i0, double &r1, double &i1)
{
    double rr0 = r0;
    double ii0 = i0;
    r0 =   i1;
    i0 = - r1;
    r1 = - ii0;
    i1 =   rr0;
}

//----------------------------------------------------------------------------
inline void qcuc_pauli_z(double &r0, double &i0)
{
    r0 = - r0;
    i0 = - i0;
}

//----------------------------------------------------------------------------
inline void qcuc_swap(double &r0, double &i0, double &r1, double &i1)
{
    swap(r0, r1);
    swap(i1, i0);
}

//----------------------------------------------------------------------------
} //namespace qc

#endif //QCUNITCALC_H

