//---------------------------------------------------------------------------
// Controlled Not gate
//---------------------------------------------------------------------------
#ifndef QC_cnotH
#define QC_cnotH
//---------------------------------------------------------------------------
#include "QCalcUnit.h"
#include "QBits.h"
//---------------------------------------------------------------------------
class QC_cnot : public QCalcUnit
{
private:
    int ControlBit;
    int TargetBit;

public:
    QC_cnot(int TargetBit,int ControllBit);
    static void calc(int t, int c, double R[], double I[], int N);
    virtual void Calc(QBits *QBits);
    virtual std::string GetName(void) const {
        return "Controlled Not";
    }


#ifdef __USE__MPI
    static void calcmpi(int t1, int c1, double R[], double I[], int N);
#endif

};
//---------------------------------------------------------------------------
#endif
