//---------------------------------------------------------------------------
// Rotate Gate
//---------------------------------------------------------------------------
#ifndef QC_rotH
#define QC_rotH
//---------------------------------------------------------------------------
#include "QCalcUnit.h"
#include "QBits.h"
//---------------------------------------------------------------------------

class QC_rot : public QCalcUnit
{
private:
    int TargetBit;
    double Theta;// Degree of rotation(Radian)
public:

    QC_rot(int _TargetBit,double degree);
    static void calc(int target, double theta, double R[], double I[], int N);
    virtual void Calc(QBits *QBits);
    virtual std::string GetName(void) const {
        return "Rot";
    }

#ifdef __USE__MPI
    static void calcmpi(int t1, double theta, double R[], double I[], int N);
#endif
};
//---------------------------------------------------------------------------
#endif
