//---------------------------------------------------------------------------
// Class for Circuits
//---------------------------------------------------------------------------
#ifndef QCircuitH
#define QCircuitH

//---------------------------------------------------------------------------
#include <vector>
#include <map>
#include <string>
#include "QBits.h"
#include "QDraw.h"
#include "QPSDraw.h"
//---------------------------------------------------------------------------

enum QC_TYPES{
  QC_NULL = -1, // No circuit
  QC_BITBOX  = 0,
  QC_WALSH   = 1,
  QC_CNOT    = 2,
  QC_CCNOT   = 3,
  QC_TEXTBOX = 4,
  QC_MEASURE = 5,
  QC_PAULIX  = 6,
  QC_PAULIY  = 7,
  QC_PAULIZ  = 8,
  QC_SWAP    = 9,
  QC_CROT    = 10,
  QC_NOT     = 11,
  QC_ROT     = 12
};


class QCircuit {


private:

protected:
  int X,Y;
  string Name;

public:

  QCircuit(int x, int y);
  static QCircuit* Create(string TypeStr, int x, int y, string Param);

  int  GetX(void)  { return X; }
  int  GetY(void)  { return Y; }
  void SetX(int x) { X = x;    }
  void SetY(int y) { Y = y;    }

  static int        GetType(string Type);
  static const char* GetTypeStr(int Type);

  virtual int        GetType(void) { return QC_NULL; }
  virtual string GetTypeStr(void) { return ""; }

  virtual void Draw(QDraw *qDraw) {}
  virtual string GetCalcText(void) {return "";}
  virtual void DrawPS(QPSDraw *psDraw) {}
  virtual string GetSaveText(void);
  virtual string GetParam(void) {return "";}
  virtual void ShowParamForm(void) {}
  virtual void Reverse(int y) {}
  virtual TRect GetOccupiedRect() {TRect rc; return rc;}
  virtual QCircuit *Clone() {QCircuit *qc = new QCircuit(X,Y); return qc;}
};

typedef vector<QCircuit *> QList;

//---------------------------------------------------------------------------
#endif //QCircuitH
