//---------------------------------------------------------------------------
// Drawing Class
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "QDraw.h"

using namespace std;
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
QDraw::QDraw(TCanvas *_Canvas) : QAbstractDraw() {
  Canvas = _Canvas;
}
//---------------------------------------------------------------------------
QDraw::~QDraw(void) {}
//---------------------------------------------------------------------------
void
QDraw::SetGridSize(int gsize) {
  GridSize = gsize;
  UnitSize = GridSize/4*3;
  TopMargin = GridSize/2;
  LeftMargin = GridSize/2 + GridSize;
}
//---------------------------------------------------------------------------
// Drawing Methods
//---------------------------------------------------------------------------
void
QDraw::DrawLine(int x1,int y1,int x2,int y2) {
  Canvas->MoveTo(x1+LeftMargin,y1+TopMargin);
  Canvas->LineTo(x2+LeftMargin,y2+TopMargin);
}
//---------------------------------------------------------------------------
void
QDraw::FrameRect(int x1, int y1, int x2, int y2) {
  TRect r2;
  r2.left = x1 + LeftMargin;
  r2.top  = y1  + TopMargin;
  r2.right =x2 + LeftMargin;
  r2.bottom=y2 + TopMargin;
  Canvas->FrameRect(r2);
}
//---------------------------------------------------------------------------
void
QDraw::FillRect(int x1, int y1, int x2, int y2) {
  TRect r2;
  r2.left = x1 + LeftMargin;
  r2.top  = y1  + TopMargin;
  r2.right =x2 + LeftMargin;
  r2.bottom=y2 + TopMargin;
  Canvas->FillRect(r2);
}
//---------------------------------------------------------------------------
void
QDraw::TextOut(int x,int y,string str) {
  AnsiString Text = str.c_str();
  int w =Canvas->TextWidth(Text);
  int h =Canvas->TextHeight(Text);
  Canvas->TextOut(LeftMargin+x-w/2,TopMargin+y-h/2,Text);
}
//---------------------------------------------------------------------------
void
QDraw::DrawCircle(int x, int y, int r) {
  x += LeftMargin;
  y += TopMargin;
  Canvas->Ellipse(x-r,y-r,x+r,y+r);
}
//---------------------------------------------------------------------------
void
QDraw::DrawFillCircle(int x, int y, int r) {
  x += LeftMargin;
  y += TopMargin;
  Canvas->Ellipse(x-r,y-r,x+r,y+r);
}
//---------------------------------------------------------------------------
void
QDraw::Ellipse(int x1,int y1,int x2,int y2) {
  Canvas->Ellipse(LeftMargin+x1,TopMargin+y1,LeftMargin+x2,TopMargin+y2);
}
//---------------------------------------------------------------------------
void
QDraw::SemiEllipse(int x1_, int y1_, int x2_, int y2_) {
  int x1 = LeftMargin + x1_;
  int y1 = TopMargin  + y1_;
  int x2 = LeftMargin + x2_;
  int y2 = TopMargin  + y2_;
  int mid = int((y1 + y2) / 2);
  Canvas->Pie(x1, y1, x2, y2, x2, mid, x1, mid);
}
//---------------------------------------------------------------------------
void
QDraw::DrawMeasure(int x,int y) {

  int d = (GridSize-UnitSize)/2;
  int x1 = x * GridSize+d;
  int y1 = y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;
  int dy = int(0.3 * UnitSize);

  SetBrushColor(clLtGray);
  SetPenColor(clBlack);
  FillRect(x1, y1, x2, y2);
  SetBrushColor(clBlack);
  FrameRect(x1, y1, x2, y2);
  SetBrushColor(clYellow);
  SemiEllipse(x1, y1 + dy, x2, y2 + dy);
  DrawLine(int(x1 + 0.5*UnitSize), int(y1 + 0.7*UnitSize),
           int(x1 + 0.7*UnitSize), int(y1 + 0.1*UnitSize));
}
//---------------------------------------------------------------------------
void
QDraw::DrawGrid(int ColumnNumber, int LineNumber) {
  int Width = ColumnNumber*GridSize;
  int Height = LineNumber*GridSize;

  SetBrushColor(clWhite);
  FillRect(0,0,Width,Height);

  // Draw holizontal lines of circuit
  SetPenColor(clGray);
  for (int i=0;i<LineNumber;i++) {
    DrawLine(0,i*GridSize+GridSize/2,Width,i*GridSize+GridSize/2);
  }
  // Draw vertical lines for each grid
  for (int i=0;i<LineNumber;i++) {
    int y = i*GridSize+GridSize/2;
    for (int j=0;j<ColumnNumber;j++) {
      int x = j*GridSize+ GridSize/2;
      DrawLine(x,y-GridSize/4,x,y+GridSize/4);
    }
  }
  //Write Bit number
  for (int i = 0; i < LineNumber; i++) {
    AnsiString as = "Q"+IntToStr(i+1);
    TextOut(-GridSize/2,i*GridSize + GridSize/2,as.c_str());
  }
}
//---------------------------------------------------------------------------

