//---------------------------------------------------------------------------
#ifndef mainH
#define mainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <ComCtrls.hpp>
#include <ImgList.hpp>
#include <ToolWin.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
#include "QManager.h"
#include "QCalcManager.h"
#include "HHelp.h"
//---------------------------------------------------------------------------
class TFMain : public TForm {
__published:
  TImage *Image;
  TMainMenu *MainMenu;
  TMenuItem *File1;
  TMenuItem *MMExit;
  TMenuItem *View1;
  TMenuItem *MMCircuitPanel;
  TMenuItem *Calc1;
        TMenuItem *MMRun;
  TMenuItem *MMShowStatus;
  TMenuItem *MMCalcText;
  TMenuItem *MMSaveAsPS;
  TSaveDialog *SaveDialog;
  TMenuItem *MMNew;
  TMenuItem *N1;
  TMenuItem *MMSave;
  TMenuItem *MMSaveAs;
  TMenuItem *Help1;
  TMenuItem *MMAbout;
  TMenuItem *MMOpen;
  TOpenDialog *OpenDialog;
  TMenuItem *Edit1;
  TMenuItem *N2;
  TMenuItem *MMSaveAsBMP;
  TMenuItem *MMHelp;
  TMenuItem *MMRemove;
  TMenuItem *N3;
  TMenuItem *MMUndo;
  TPrintDialog *PrintDialog;
  TMenuItem *N4;
  TMenuItem *MMPrint;
  TPrinterSetupDialog *PrinterSetupDialog;
  TMenuItem *MMPrintSetup;
  TMenuItem *MMPreViewPrint;
  TMenuItem *N5;
  TMenuItem *MMImportResult;
  TMenuItem *ViewMode1;
  TMenuItem *MMShowAll;
  TMenuItem *MMShowNonZero;
        TImageList *IconList;
        TToolBar *ToolBar;
        TToolButton *TBNew;
        TToolButton *TBOpen;
        TToolButton *TBSave;
        TToolButton *TBRemove;
        TToolButton *TBUndo;
        TToolButton *ToolButton1;
        TToolButton *TBHelp;
        TToolButton *TBRun;
        TToolButton *ToolButton4;
        TToolButton *ToolButton2;
        TToolButton *TBSaveAsBMP;
        TToolButton *TBSaveAsPS;
        TToolButton *ToolButton3;
  void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
  void __fastcall ImageMouseDown(TObject *Sender,
                                 TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall MMCircuitPanelClick(TObject *Sender);
  void __fastcall MMExitClick(TObject *Sender);
  void __fastcall MMSaveAsPSClick(TObject *Sender);
  void __fastcall MMNewClick(TObject *Sender);
  void __fastcall FormMouseWheel(TObject *Sender, TShiftState Shift,
                                 int WheelDelta, TPoint &MousePos, bool &Handled);
  void __fastcall MMSaveClick(TObject *Sender);
  void __fastcall MMSaveAsClick(TObject *Sender);
  void __fastcall MMAboutClick(TObject *Sender);
  void __fastcall MMOpenClick(TObject *Sender);
  void __fastcall ImageDblClick(TObject *Sender);
  void __fastcall MMSaveAsBMPClick(TObject *Sender);
  void __fastcall MMHelpClick(TObject *Sender);
  void __fastcall ImageClick(TObject *Sender);
  void __fastcall MMRunClick(TObject *Sender);
  void __fastcall FormDeactivate(TObject *Sender);
  void __fastcall MMRemoveClick(TObject *Sender);
  void __fastcall MMUndoClick(TObject *Sender);
  void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
  void __fastcall MMPrintClick(TObject *Sender);
  void __fastcall MMPrintSetupClick(TObject *Sender);
  void __fastcall MMPreViewPrintClick(TObject *Sender);
  void __fastcall MMImportResultClick(TObject *Sender);
  void __fastcall MMShowNonZeroClick(TObject *Sender);
  void __fastcall MMShowAllClick(TObject *Sender);
private:

  void EraseCircuit(int mx, int my);
  void SelectCircuit(int mx, int my);
  void PutCircuit(int mx, int my);
  void ChangeSize(int Line,int Column);
  void UpdateCaption(void);
  void ModifyCircuit(void);
  void ImportResult(char *FileName);

  bool Save(void);
  bool SaveQuery(void);
  void OpenFile(AnsiString FileName);

  int MX,MY;// Mouse Position

  static const int MAX_WIDTH;
  static const int MAX_HEIGHT;
  Htmlhelp * htmlhelp;

public:
  //---------------------------------------------------------------------------
  QManager *qManager;
  QDraw *qDraw;
  QBits *qBits;
  void WMDropFiles(TWMDropFiles &Msg);
  __fastcall TFMain(TComponent* Owner);

  BEGIN_MESSAGE_MAP
    MESSAGE_HANDLER( WM_DROPFILES , TWMDropFiles, WMDropFiles )
  END_MESSAGE_MAP( TForm )

};
//---------------------------------------------------------------------------
const int TFMain::MAX_WIDTH = 640;
const int TFMain::MAX_HEIGHT = 400;

extern PACKAGE TFMain *FMain;
//---------------------------------------------------------------------------
#endif
