#include "StdAfx.h"
#include "IndexColor.h"


using lgr::color4f;

int IndexColor::NumColorCycles(void)
{
	return 6;
}

color4f IndexColor::GetColor(int idx)
{
	switch(idx % NumColorCycles())
	{
	case 0: return color4f(1, 0, 0, 1); break;
	case 1: return color4f(0, 1, 0, 1); break;
	case 2: return color4f(0, 0, 1, 1); break;
	case 3: return color4f(1, 1, 0, 1); break;
	case 4: return color4f(1, 0, 1, 1); break;
	case 5: return color4f(0, 1, 1, 1); break;
	default:
		assert(false);
		return color4f(0, 0, 0, 0);
	}
}

color4f IndexColor::GetColorRev(int idx)
{
	color4f c = GetColor(idx);
	return color4f(1.0 - c.r(), 1.0 - c.g(), 1.0 - c.b(), c.a());
}
