#pragma once

#include <C2/gl/GlslShader.h>
#include <C2/gl/GlewFramebuffer.h>
#include <C2/gl/GlTextureObject.h>


class ShadowBuffer
{
public:
	ShadowBuffer(void)
	{
		m_ShadowMapTexels = 2048;
		m_IsInitialized = false;

		m_ShadowmapWidth = 0;
		m_ShadowmapHeight = 0;
	}

	void InitializeShadowbufferOnce(void);
	void InitializeShadowbuffer(void);
	void SetGLShadowMatrix(const lm::vec3f& light_dir, const lm::vec3f& range_center, float DepthRange, float MapWidth) const;

	void UpdateShadowMatrix(void);

	void BeginCreateShadowmap(void);
	void EndCreateShadowmap(void);

	int GetWidth(void) const;
	int GetHeight(void) const;
	void SetBufSizeToSquare(void);

private:
	void InitializeDethBuffer(void);
	void InitializeColorBuffer(void);
	void AssignFBOToFrameBufObjects(void);

public:
	lib_gl::GlFramebuffer m_Fbo;
	lib_gl::GlTextureObject m_ShadowBuffer;
	lib_gl::GlRenderbuffer m_RenderBuffer;

	lm::matrix4f m_ShadowMatrix;

private:
	int m_ShadowmapWidth;
	int m_ShadowmapHeight;

	int m_ShadowMapTexels;

	bool m_IsInitialized;
};
