import sys
import re

from VersionInfo import *


def isMatch(line, reg):
	m = re.search(reg, line)
	if m is None:
		return False
	return True

def isMatchHead(line, head):
	return isMatch(line, "^" + head + "(.*)")

def printRet(line, dst):
	print(line,)
	print("->")
	print(dst)
	return dst

def embedVersion(line):
	version_info = "VersionInfoVersion="
	if isMatchHead(line, version_info):
		return printRet(line, version_info + getFullVersion() + "\n")

	app_vn = "AppVerName=QtGeoViewer "
	if isMatchHead(line, app_vn):
		return printRet(line, app_vn + getMainVersion() + "\n")

	base_fn = "OutputBaseFilename=(.+?)(_([0-9]+))+"
	m = re.search(base_fn, line)
	if m == None:
		return line

	out = ""
	out += "OutputBaseFilename=" + m.group(1)
	out += "_" + getMajorVersion()
	out += "_" + getMinorVersion()
	out += "_" + getBuildNumber()
	out += "_" + getVCSRevision()
	out += "\n"
	return printRet(line, out)


def setVersion(filename):
	dst_build_no = getBuildNumber()
	dst_version  = getVCSRevision()

	lines = []
	for line in open(filename):
		line = embedVersion(line)
		lines.append(line)

	f = open(filename, "w")
	for line in lines:
		f.write(line)
	f.close()

def main():
	argv = sys.argv
	argc = len(argv)
	if argc != 2:
		print("Usage: " + argv[0] + " installer_script")
		return

	setVersion(argv[1])

main()
