#include "stdafx.h"
#include "PlyHeader.h"

#include <cassert>


namespace lib_geo
{
namespace ply
{


void VertPropIdx::Clear(void)
{
	vX = -1;
	vY = -1;
	vZ = -1;
	nX = -1;
	nY = -1;
	nZ = -1;
	cR = -1;
	cG = -1;
	cB = -1;
	cA = -1;
}

int VertPropIdx::GetMaxPropIdx(void) const
{
	int max_vprop = 0;
	max_vprop = (std::max)(max_vprop, vX);
	max_vprop = (std::max)(max_vprop, vY);
	max_vprop = (std::max)(max_vprop, vZ);
	max_vprop = (std::max)(max_vprop, nX);
	max_vprop = (std::max)(max_vprop, nY);
	max_vprop = (std::max)(max_vprop, nZ);
	max_vprop = (std::max)(max_vprop, cR);
	max_vprop = (std::max)(max_vprop, cG);
	max_vprop = (std::max)(max_vprop, cB);
	max_vprop = (std::max)(max_vprop, cA);
	max_vprop += 1;

	return max_vprop;
}


PlyHeader::PlyHeader(void)
{
	Clear();
}

void PlyHeader::Clear(void)
{
	m_FormatType.clear();

	m_NumVerts = 0;
	m_VPI.Clear();

	m_NumFaces = 0;

	m_Comments.clear();
}

int PlyHeader::GetMaxPropIdx(void) const
{
	return m_VPI.GetMaxPropIdx();
}

bool PlyHeader::HasNormal(void) const
{
	bool bx = (m_VPI.nX != -1);
	bool by = (m_VPI.nY != -1);
	bool bz = (m_VPI.nZ != -1);

	assert( bx == by && by == bz );
	return (bx && by && bz);
}

bool PlyHeader::HasCol(void) const
{
	bool br = (m_VPI.cR != -1);
	bool bg = (m_VPI.cG != -1);
	bool bb = (m_VPI.cB != -1);

	assert(br == bg && bg == bb);
	return (br && bg && bb);
}

int PlyHeader::NumColorElems(void) const
{
	if (!HasCol())
		return 0;

	if (m_VPI.cA == -1)
		return 3;
	else
		return 4;
}


}
}
