#pragma once

#include <C2/gl/GlTextureObject.h>

#include "../SDL_Include.h"



namespace gl
{


enum class TexSampleMode
{
	Nearest,
	Linear,
	Mipmap,
};


class TextureConfig
{
public:
	TextureConfig(void)
	{
		m_EnableCompress = false;
		m_SampleMode     = TexSampleMode::Mipmap;
	}

	std::string SampleModeToStr(void) const
	{
		switch (m_SampleMode)
		{
		case TexSampleMode::Nearest : return "Nearest";
		case TexSampleMode::Linear  : return "Linear";
		case TexSampleMode::Mipmap  : return "Mipmap";
		default:
			assert(false);
			return "";
		}
	}

	void SetModeByStr(const std::string& s)
	{
		if (s == "Nearest")
		{
			m_SampleMode = TexSampleMode::Nearest;
		}
		else if (s == "Linear")
		{
			m_SampleMode = TexSampleMode::Linear;
		}
		else if (s == "Mipmap")
		{
			m_SampleMode = TexSampleMode::Mipmap;
		}
		else
		{
			m_SampleMode = TexSampleMode::Mipmap;
		}
	}

public:
	bool m_EnableCompress;
	TexSampleMode m_SampleMode;
};


class GlTexture
{
public:
	GlTexture(void);
	virtual ~GlTexture(void);

	bool InitializeTexture(void);
	void FinalizeTexture(void);

	void BindGL(void);
	void SetTextureGL(const TextureConfig& config);
	void SetTextureGLAndReleaseImage(const TextureConfig& config);

	bool HasImage(void) const;
	bool HasTextureObject(void) const;

	bool LoadTextureFromFile(const char* filename, bool flip_y);

	bool SetFromSDLSurface(SDL_Surface* surface);

	void SetName( const std::string& name ) { m_Name = name; }
	const std::string& GetName(void) const { return m_Name; }

	const std::string& GetSourceFilePath(void) const
	{
		return m_SourceFile;
	}

private:
	GlTexture(const GlTexture&) {}
	void operator=(const GlTexture&) {}

	void ReleaseImage(void);
	void ReleaseImageBufMain(void);

private:
	lib_gl::GlTextureObject m_TexObject;
	SDL_Surface*            m_TexSDL;
	std::string             m_Name;
	std::string             m_SourceFile;
};


}
