#pragma once



namespace geom
{


class SceneNode;


class BoneWeight
{
public:
	BoneWeight(void):
		m_Vid(-1),
		m_Weight(0.0f)
	{
	}

public:
	int m_Vid;
	float m_Weight;
};


class Bone
{
public:
	Bone(void)
	{
		m_Index = -1;
		m_RefNode = NULL;
	}

	lm::vec3f VertGolbalToLocal(const lm::vec3f& v) const;

	void SetOffset(const lm::matrix4f& offset);

public:
	int m_Index;
	std::string m_Name;

	std::vector<BoneWeight> m_Weights;

	lm::matrix4f m_Offset;

	SceneNode* m_RefNode;
};


class BoneDeform
{
public:
	void Clear(void)
	{
		m_Bones.clear();
		m_SrcVertPos.clear();
	}

	Bone* FindBone(const std::string& name);

public:
	boost::ptr_vector<Bone> m_Bones;
	std::vector<lm::vec3f> m_SrcVertPos;
};


}
