#include "stdafx.h"
#include "MaterialPresetDlg.h"

MaterialPresetDlg::MaterialPresetDlg(QWidget *parent)
	: QDialog(parent)
{
	ui.setupUi(this);

	Qt::WindowFlags flags = windowFlags() & (~Qt::WindowContextHelpButtonHint);
	flags = flags | Qt::WindowMinimizeButtonHint;
	flags = flags | Qt::WindowCloseButtonHint;
	setWindowFlags(flags);

	allRadios.push_back(ui.radioJewelTurquoise);
	allRadios.push_back(ui.radioJewelEmerald);
	allRadios.push_back(ui.radioJewelObsidian);
	allRadios.push_back(ui.radioJewelRubby);
	allRadios.push_back(ui.radioJewelPearl);
	allRadios.push_back(ui.radioJewelJade);

	allRadios.push_back(ui.radioMetalSilver);
	allRadios.push_back(ui.radioMetalBrass);
	allRadios.push_back(ui.radioMetalChrome);
	allRadios.push_back(ui.radioMetalGold);
	allRadios.push_back(ui.radioMetalCopper);
	allRadios.push_back(ui.radioMetalBronze);

	allRadios.push_back(ui.radioPlasticYellow);
	allRadios.push_back(ui.radioPlasticBlack);
	allRadios.push_back(ui.radioPlasticGreen);
	allRadios.push_back(ui.radioPlasticWhite);
	allRadios.push_back(ui.radioPlasticRed);
	allRadios.push_back(ui.radioPlasticCyan);

	allRadios.push_back(ui.radioRubberYellow);
	allRadios.push_back(ui.radioRubberBlack);
	allRadios.push_back(ui.radioRubberGreen);
	allRadios.push_back(ui.radioRubberWhite);
	allRadios.push_back(ui.radioRubberRed);
	allRadios.push_back(ui.radioRubberCyan);

	AssignSlots();
}

MaterialPresetDlg::~MaterialPresetDlg()
{
}

void MaterialPresetDlg::AssignSlots()
{
	for (QRadioButton* r : allRadios)
	{
		connect(
			r,
			SIGNAL(clicked()),
			this,
			SLOT(onRadioClicked()));
	}
}

void MaterialPresetDlg::on_buttonBox_accepted()
{
	accept();
}

void MaterialPresetDlg::on_buttonBox_rejected()
{
	reject();
}

void MaterialPresetDlg::onRadioClicked()
{
	QRadioButton* sr = dynamic_cast<QRadioButton*>(QObject::sender());
	for (QRadioButton* r : allRadios)
	{
		r->blockSignals(true);
		r->setChecked(sr == r);
		r->blockSignals(false);
	}

	emit OnMatChanged();
}

lgr::MaterialSamples::MaterialSampleType MaterialPresetDlg::GetSelectedType()
{
	if ( ui.radioJewelEmerald   ->isChecked() ) return lgr::MaterialSamples:: MAT_EMERALD       ;
	if ( ui.radioJewelJade      ->isChecked() ) return lgr::MaterialSamples:: MAT_JADE          ;
	if ( ui.radioJewelObsidian  ->isChecked() ) return lgr::MaterialSamples:: MAT_OBSIDIAN      ;
	if ( ui.radioJewelPearl     ->isChecked() ) return lgr::MaterialSamples:: MAT_PEARL         ;
	if ( ui.radioJewelRubby     ->isChecked() ) return lgr::MaterialSamples:: MAT_RUBY          ;
	if ( ui.radioJewelTurquoise ->isChecked() ) return lgr::MaterialSamples:: MAT_TURQUOISE     ;
	if ( ui.radioMetalBrass     ->isChecked() ) return lgr::MaterialSamples:: MAT_BRASS         ;
	if ( ui.radioMetalBronze    ->isChecked() ) return lgr::MaterialSamples:: MAT_BRONZE        ;
	if ( ui.radioMetalChrome    ->isChecked() ) return lgr::MaterialSamples:: MAT_CHROME        ;
	if ( ui.radioMetalCopper    ->isChecked() ) return lgr::MaterialSamples:: MAT_COPPER        ;
	if ( ui.radioMetalGold      ->isChecked() ) return lgr::MaterialSamples:: MAT_GOLD          ;
	if ( ui.radioMetalSilver    ->isChecked() ) return lgr::MaterialSamples:: MAT_SILVER        ;
	if ( ui.radioPlasticBlack   ->isChecked() ) return lgr::MaterialSamples:: MAT_BLACK_PLASTIC ;
	if ( ui.radioPlasticCyan    ->isChecked() ) return lgr::MaterialSamples:: MAT_CYAN_PLASTIC  ;
	if ( ui.radioPlasticGreen   ->isChecked() ) return lgr::MaterialSamples:: MAT_GREEN_PLASTIC ;
	if ( ui.radioPlasticRed     ->isChecked() ) return lgr::MaterialSamples:: MAT_RED_PLASTIC   ;
	if ( ui.radioPlasticWhite   ->isChecked() ) return lgr::MaterialSamples:: MAT_WHITE_PLASTIC ;
	if ( ui.radioPlasticYellow  ->isChecked() ) return lgr::MaterialSamples:: MAT_YELLOW_PLASTIC;
	if ( ui.radioRubberBlack    ->isChecked() ) return lgr::MaterialSamples:: MAT_BLACK_RUBBER  ;
	if ( ui.radioRubberCyan     ->isChecked() ) return lgr::MaterialSamples:: MAT_CYAN_RUBBER   ;
	if ( ui.radioRubberGreen    ->isChecked() ) return lgr::MaterialSamples:: MAT_GREEN_RUBBER  ;
	if ( ui.radioRubberRed      ->isChecked() ) return lgr::MaterialSamples:: MAT_RED_RUBBER    ;
	if ( ui.radioRubberWhite    ->isChecked() ) return lgr::MaterialSamples:: MAT_WHITE_RUBBER  ;
	if ( ui.radioRubberYellow   ->isChecked() ) return lgr::MaterialSamples:: MAT_YELLOW_RUBBER ;

	return lgr::MaterialSamples::MAT_NONE;
}
