#include "StdAfx.h"
#include "MyGLWidget.h"

#include <cassert>


QGLFormat CreateGLFormat(void)
{
	QGLFormat f(QGL::SampleBuffers);
	//f.setVersion(3, 2);
	f.setProfile(QGLFormat::CoreProfile);
	return f;
}

MyGLWidget::MyGLWidget( QWidget* parent )
	: QGLWidget(CreateGLFormat(), parent)
{
	m_View = NULL;

	connect(&m_RenderTimer, SIGNAL(timeout()), this, SLOT(updateGL()));
	m_RenderTimer.setInterval( DEFALUT_TIMER_INTERVAL );

	m_IsOnPan   = false;
	m_IsOnPinch = false;
}


void MyGLWidget::SetViewer( QtViewBase* viewer )
{
	assert( m_View == NULL );
	m_View = viewer;
}


void MyGLWidget::ActivateGesture(void)
{
	grabGesture(Qt::PanGesture);
	grabGesture(Qt::PinchGesture);
	grabGesture(Qt::SwipeGesture);
}


void MyGLWidget::paintGL(void)
{
	if( m_View != NULL )
		m_View->OnPaint();
}

void MyGLWidget::resizeGL(int width , int height )
{
	if(m_View != NULL)
		m_View->OnResize( width , height );
}


void MyGLWidget::mousePressEvent(QMouseEvent *e)
{
	if(IsEnableMouseEvent())
		m_View->OnMousePress(e);
}

void MyGLWidget::mouseReleaseEvent(QMouseEvent *e)
{
	if(IsEnableMouseEvent())
		m_View->OnMouseRelease(e);
}

void MyGLWidget::mouseDoubleClickEvent(QMouseEvent *e)
{
	if(IsEnableMouseEvent())
		m_View->OnMouseDoubleClick(e);
}

void MyGLWidget::mouseMoveEvent(QMouseEvent *e)
{
	if(IsEnableMouseEvent())
		m_View->OnMouseMove(e);
}

void MyGLWidget::moveEvent(QMoveEvent *e)
{
	//if( m_View != NULL )
}

void MyGLWidget::wheelEvent(QWheelEvent *e)
{
	if(IsEnableMouseEvent())
		m_View->OnWheel(e);
}

void MyGLWidget::keyPressEvent(QKeyEvent *e)
{
	if( m_View != NULL )
		m_View->OnKeyPress(e);

	QGLWidget::keyPressEvent(e);
}

void MyGLWidget::keyReleaseEvent(QKeyEvent *e)
{
	if( m_View != NULL )
		m_View->OnKeyRelease(e);

	QGLWidget::keyReleaseEvent(e);
}

void MyGLWidget::StartAnimation(void)
{
	m_RenderTimer.start();
}

void MyGLWidget::StopAnimation(void)
{
	m_RenderTimer.stop();
}

bool MyGLWidget::AnimationRunning(void) const
{
	return m_RenderTimer.isActive();
}

int MyGLWidget::GetAnimationInterval(void) const
{
	return m_RenderTimer.interval();
}

void MyGLWidget::SetAnimationInterval(int interval)
{
	m_RenderTimer.setInterval( interval );
}


bool MyGLWidget::IsEnableMouseEvent(void) const
{
	if(m_View == NULL)
		return false;

	if(m_IsOnPan)
		return false;

	if(m_IsOnPinch)
		return false;

	return true;
}


bool MyGLWidget::event(QEvent *event)
{
	if (event->type() == QEvent::Gesture)
		return gestureEvent(static_cast<QGestureEvent*>(event));

	return QWidget::event(event);
}

bool MyGLWidget::gestureEvent(QGestureEvent *event)
{
	if (QGesture *swipe = event->gesture(Qt::SwipeGesture))
	{
		swipeTriggered(static_cast<QSwipeGesture *>(swipe));
	}
	else if (QGesture *pan = event->gesture(Qt::PanGesture))
	{
		panTriggered(static_cast<QPanGesture *>(pan));
	}

	if (QGesture *pinch = event->gesture(Qt::PinchGesture))
	{
		pinchTriggered(static_cast<QPinchGesture *>(pinch));
	}

	return true;
}

const char* MyGLWidget::GestureState(QGesture* g) const
{
	switch(g->state())
	{
	case Qt::GestureStarted  : return "started";
	case Qt::GestureUpdated  : return "updated";
	case Qt::GestureFinished : return "finished";
	case Qt::GestureCanceled : return "canceled";
	default                  : return "unknown";
	}
}

void MyGLWidget::swipeTriggered(QSwipeGesture *gesture)
{
}

void MyGLWidget::panTriggered(QPanGesture *gesture)
{
	if(gesture->state() == Qt::GestureStarted)
	{
		m_IsOnPan = true;
	}
	else if(gesture->state() != Qt::GestureUpdated)
	{
		m_IsOnPan = false;
	}

	if(m_View != NULL)
		m_View->OnGesturePan(gesture);
}

void MyGLWidget::pinchTriggered(QPinchGesture *gesture)
{
	if(gesture->state() == Qt::GestureStarted)
	{
		m_IsOnPinch = true;
	}
	else if(gesture->state() != Qt::GestureUpdated)
	{
		m_IsOnPinch = false;
	}

	if(m_View != NULL)
		m_View->OnGesturePinch(gesture);
}
