#pragma once

#include <QDialog>
#include "ui_QGVAboutDlg.h"

#include "AppVersion.h"


class QDomDocument;

class QGVAboutDlg : public QDialog
{
	Q_OBJECT

public:
	QGVAboutDlg(QWidget *parent = 0);
	~QGVAboutDlg();

	std::string GetInfo(void);

private:
	bool GetVersionFromWeb(AppVersion& version, QString& vs);
	bool GetVersionTextFromWeb(QString& version);
	bool VersionTextToVal(QString& version);
	bool DownloadReleaseRSS(void);

	void ShowProjectPage(void);

	QString GetTmpPath(void);

	bool ReadXmlBuf(QDomDocument& xml, QString& version);

private slots:
	void on_buttonBox_accepted();

	void on_commandOpenProjectPage_clicked();

	void on_commandCheckUpdate_clicked();

private:
	Ui::QGVAboutDlg ui;
};
