#include "stdafx.h"
#include "QtFreeScroll.h"

#include "Modifier.h"
#include "MouseButtons.h"

QtFreeScroll::QtFreeScroll(QWidget *parent)
	: QPushButton(parent)
{
	ui.setupUi(this);
}

QtFreeScroll::~QtFreeScroll()
{
}

void QtFreeScroll::mousePressEvent(QMouseEvent *e)
{
	Modifier m(e);
	MouseButtons mouse(e);

	iniPos = e->pos();
	iniMousePos = QCursor::pos();
	roundRest = 0.0;

	if (mouse.IsRightOnly())
	{
		emit onReset();
	}

	QPushButton::mousePressEvent(e);
}

void QtFreeScroll::mouseMoveEvent(QMouseEvent *e)
{
	Modifier m(e);
	MouseButtons mouse(e);

	int epx = e->pos().x();
	QPointF df = e->pos() - iniPos;

	if (mouse.IsLeftOnly())
	{
		QPointF add = df;
		if (m.Flag_S())
		{
			add *= 0.05;
		}

		int ai = (int)add.x();
		double rest = add.x() - (double)ai;
		roundRest += rest;
		if (roundRest >= 1.0)
		{
			roundRest -= 1.0;
			ai += 1;
		}
		else if (roundRest <= -1.0)
		{
			roundRest += 1.0;
			ai -= 1;
		}

		blockSignals(true);
		QCursor::setPos(iniMousePos);
		blockSignals(false);

		if (ai != 0)
			emit onScroll(ai);
	}

	QPushButton::mouseMoveEvent(e);
}
