#pragma once

#include <cassert>
#include <C2/gl/Viewport.h>

#include <QObject>
#include <QPanGesture>
#include <QMouseEvent>



class MyGLWidget;


class QtViewBase : public QObject
{
	Q_OBJECT

public:
	QtViewBase(void)
	{
		m_Parent = NULL;
	}

	virtual ~QtViewBase(void)
	{}

	virtual bool InitializeView(MyGLWidget* ParentWidget);
	virtual void FinalizeView(void);

	virtual void OnPaint(void) {}
	virtual void OnResize(int width, int height) {}

	virtual void OnMousePress(QMouseEvent *e) {}
	virtual void OnMouseRelease(QMouseEvent *e) {}
	virtual void OnMouseDoubleClick(QMouseEvent *e) {}
	virtual void OnMouseMove(QMouseEvent *e) {}

	virtual void OnWheel(QWheelEvent *e) {}

	virtual void OnKeyPress(QKeyEvent *e) {}
	virtual void OnKeyRelease(QKeyEvent *e) {}

	virtual void OnGesturePan(QPanGesture *gesture) {}
	virtual void OnGesturePinch(QPinchGesture *gesture) {}


	MyGLWidget* GetParentWidget(void)
	{
		assert( m_Parent != NULL );
		return m_Parent;
	}

	const MyGLWidget* GetParentWidget(void) const
	{
		assert( m_Parent != NULL );
		return m_Parent;
	}


public:
	lib_gl::Viewport m_Viewport;

private:
	MyGLWidget* m_Parent;
};
