#include "StdAfx.h"
#include "ConstantShader.h"

#include <LibTest/DebugStream.h>

#include "../../GLUtility/ShaderUtil.h"



ConstantShader::ConstantShader(ShaderContext* context) :
	ShaderInterface(context)
{
}

bool ConstantShader::Initialize(const std::string& shader_libdir)
{
	std::string vert_filename = shader_libdir + "constant_shader.vert";
	std::string frag_filename = shader_libdir + "constant_shader.frag";

	return ShaderUtil::InitShaderStd(m_Shader, frag_filename, vert_filename);
}


void ConstantShader::BeginShader(void)
{
	m_Shader.BeginShader();
}

void ConstantShader::EndShader(void)
{
	m_Shader.EndShader();
}
