#include "StdAfx.h"
#include "MatcapShader.h"

#include <LibTest/DebugStream.h>

#include "../../GLUtility/ShaderUtil.h"



MatcapShader::MatcapShader(ShaderContext* context) :
	ShaderInterface(context)
{
}

bool MatcapShader::Initialize(const std::string& shader_libdir)
{
	std::string vert_filename = shader_libdir + "matcap.vert";
	std::string frag_filename = shader_libdir + "matcap.frag";

	return ShaderUtil::InitShaderStd(m_Shader, frag_filename, vert_filename);
}


void MatcapShader::BeginShader(void)
{
	m_Shader.BeginShader();

	SceneMain* scene = m_Context->m_Scene;

	glUniform1i(m_Shader.GetUniformLocation("tex_matcap"), 1);
	glUniform1i(m_Shader.GetUniformLocation("enable_matcap"), false);

	glActiveTexture(GL_TEXTURE0);
	glUniform1i(m_Shader.GetUniformLocation("tex_color"), 0);
}

void MatcapShader::EndShader(void)
{
	m_Shader.EndShader();
}

void MatcapShader::SetMatcap(gl::MatcapImage* matcap)
{
	if (matcap == NULL)
	{
		glUniform1i(m_Shader.GetUniformLocation("enable_matcap"), false);
		return;
	}

	glActiveTexture(GL_TEXTURE1);
	matcap->BindTexture();

	glUniform1i(m_Shader.GetUniformLocation("tex_matcap"), 1);
	glUniform1i(m_Shader.GetUniformLocation("enable_matcap"), matcap->HasImage());

	glActiveTexture(GL_TEXTURE0);
}
