varying vec4 v_projected;

void main (void)
{
	float d = (v_projected.z / v_projected.w + 1.0) * 0.5;

	if(d < 1.0/3.0)
	{
		gl_FragColor = vec4( d / (1.0/3.0) , 0.0 , 0.0 , 1.0 );
	}
	else if(d < 2.0/3.0)
	{
		gl_FragColor = vec4( 1.0 , (d - (1.0/3.0)) / (1.0/3.0) , 0.0 , 1.0 );
	}
	else
	{
		gl_FragColor = vec4( 1.0 - (d - (2.0/3.0)) / (1.0/3.0) , 1.0 , (d - (2.0/3.0)) / (1.0/3.0) , 1.0 );
	}

	gl_FragColor.w = gl_FrontMaterial.diffuse.w;
}
