#pragma once

#include "QtViewBase.h"

#include "GLWidgetList.h"

#include <C2/gl/Projection.h>
#include <C2/gl/Manipulator.h>

#include <LibQtGeoViewerCore/SceneMain.h>


enum class View2DTexSrc
{
	Color,
	Normal,
};


class View2D : public QtViewBase
{
	Q_OBJECT

public:
	View2D(void);

	virtual bool InitializeView(MyGLWidget* ParentWidget);
	void RegisterScene(SceneMain* scene);

	void ResetView(void);

	virtual void FinalizeView(void);

	virtual void OnPaint(void);
	virtual void OnResize(int width, int height);

	virtual void OnMousePress(QMouseEvent *e);
	virtual void OnMouseRelease(QMouseEvent *e);
	virtual void OnMouseDoubleClick(QMouseEvent *e);
	virtual void OnMouseMove(QMouseEvent *e);

	virtual void OnWheel(QWheelEvent *e);

	void FitView(void);

	void RepaintParent(void);

	void ChangeTextureSource(View2DTexSrc src);

private:
	gl::GlTexture* GetPrimaryTexture(void);

	void DrawBackTexture(void);
	void DrawOptions(void);
	void DrawObjects(void);
	void DrawMeshBuf(MeshBuf* mbuf);

	void GetObjRange(const GeomObject* obj, lm::range2f& r) const;

	void SetGLVT(float x, float y);

	void DrawObjectWire(MeshBuf* mbuf);
	void DrawObjectSelVerts(MeshBuf& mbuf);
	void DrawObjectVerts(lib_geo::BaseMesh& mesh);

	void DrawRangeRect(const lm::range2f& r);

public:
	GLWidgetList* m_Widgets;

	SceneMain* m_Scene;

	lib_gl::CameraManipulator m_Manip;
	lib_gl::OrthoProjection   m_Projection;

	QPointF m_LastMousePos;

	bool m_DrawVerts;
	bool m_EnableTexture;
	bool m_UseFixTexute;

	bool m_RepeatTexture;

private:
	View2DTexSrc m_TexSource;
};
