#include "StdAfx.h"
#include "ViewConfigDlg.h"

#include <QKeyEvent>



ViewConfigDlg::ViewConfigDlg(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);

	m_Config = NULL;
}

ViewConfigDlg::~ViewConfigDlg()
{
}

void ViewConfigDlg::InitializeConfigDlg(View3DConfig* config)
{
	m_Config = config;

	ui.sliderPointSize->blockSignals(true);
	ui.sliderPointSize->setValue(config->m_PointSize);
	ui.sliderPointSize->blockSignals(false);

	int normal_len = (int)((std::min)(1.0f, config->m_NormalLength) * ui.sliderNormalLen->maximum());
	ui.sliderNormalLen->blockSignals(true);
	ui.sliderNormalLen->setValue(normal_len);
	ui.sliderNormalLen->blockSignals(false);

	int index_len = (int)((std::min)(1.0f, config->m_IndexLineLen) * ui.sliderIndexLine->maximum());
	ui.sliderIndexLine->blockSignals(true);
	ui.sliderIndexLine->setValue(index_len);
	ui.sliderIndexLine->blockSignals(false);

	UpdateValueLabels();
}


void ViewConfigDlg::keyPressEvent(QKeyEvent *e)
{
	if(e->key() == Qt::Key_Escape)
	{
		close();
		return;
	}
}


void ViewConfigDlg::UpdateValueLabels(void)
{
	QString PointSizeStr = QString::number(ui.sliderPointSize->value());
	ui.labelPointSizeValue->setText(PointSizeStr);

	QString NormalLenStr = QString::number(GetNormalLenValue());
	ui.labelNormalLenValue->setText(NormalLenStr);

	QString IndexLineStr = QString::number(GetIndexLineLen());
	ui.labelIndexLineValue->setText(IndexLineStr);
}

void ViewConfigDlg::on_sliderPointSize_valueChanged(int value)
{
	UpdateValueLabels();

	m_Config->m_PointSize = ui.sliderPointSize->value();

	emit ConfigChanged();
}

void ViewConfigDlg::on_sliderNormalLen_valueChanged(int value)
{
	UpdateValueLabels();

	m_Config->m_NormalLength = GetNormalLenValue();

	emit ConfigChanged();
}

float ViewConfigDlg::GetNormalLenValue(void) const
{
	int val = ui.sliderNormalLen->value();
	int maxval = ui.sliderNormalLen->maximum();
	return (float)val / (float)maxval;
}

void ViewConfigDlg::on_sliderIndexLine_valueChanged(int value)
{
	UpdateValueLabels();

	m_Config->m_IndexLineLen = GetIndexLineLen();

	emit ConfigChanged();
}

float ViewConfigDlg::GetIndexLineLen(void) const
{
	int val = ui.sliderIndexLine->value();
	int maxval = ui.sliderIndexLine->maximum();
	return (float)val / (float)maxval;
}
