
#pragma once

#include "GlInclude.h"


namespace lib_gl
{


// ------------------------------------------------------------------------------------------
//! vf̃fBXvCXg
class GlDisplayListArray
{
public:
	GlDisplayListArray(void);
	~GlDisplayListArray(void);
	
	//! fBXvCXg̎擾AJ
	bool GenerateList( GLuint i_ListLength );
	void ReleaseList(void);

	//! ς݃fBXvCXgIDԂ
	GLuint GetListLength(void) const;
	//! fBXvCXgIDz񂪏ĂȂǂm߂
	bool IsEmpty(void) const;

	//! _O̊Jn
	void BeginList( GLuint i_ListIdIndex , GLenum ListMode = GL_COMPILE );
	//! Xg̓o^I
	void EndList(void);

	//! fBXvCXgĂяo
	void CallList( GLuint i_ListIdIndex );

private:
	GlDisplayListArray(const GlDisplayListArray&) {}
	void operator=(const GlDisplayListArray&) {}

protected:
	GLuint m_ListID;     //!< fBXvCXgIDz̐擪ID
	GLuint m_ListLength; //!< ς݃fBXvCXgIDz̗vf
};



// ------------------------------------------------------------------------------------------
// GlDisplayListArray implements


inline GlDisplayListArray::GlDisplayListArray(void)
{
	m_ListID     = 0;
	m_ListLength = 0;
}

inline GlDisplayListArray::~GlDisplayListArray(void)
{
	if( IsEmpty() == false )
		glDeleteLists( m_ListID , m_ListLength );
}

//! fBXvCXg̎擾AJ
inline bool GlDisplayListArray::GenerateList( GLuint i_ListLength )
{
	m_ListID = glGenLists( i_ListLength );
	if( m_ListID == 0 ) return false;

	m_ListLength = i_ListLength;
	return true;
}

inline void GlDisplayListArray::ReleaseList(void)
{
	if( m_ListID != 0 )
	{
		glDeleteLists( m_ListID , 1 );
		m_ListID     = 0;
		m_ListLength = 0;
	}
}

//! ς݃fBXvCXgIDԂ
inline GLuint GlDisplayListArray::GetListLength(void) const
{
	return m_ListLength;
}

//! fBXvCXgIDz񂪏ĂȂǂm߂
inline bool GlDisplayListArray::IsEmpty(void) const
{
	return ( m_ListLength == 0 );
}

//! _O̊Jn
inline void GlDisplayListArray::BeginList( GLuint i_ListIdIndex , GLenum ListMode )
{
	glNewList( m_ListID + i_ListIdIndex , ListMode );
}

//! Xg̓o^I
inline void GlDisplayListArray::EndList(void)
{
	glEndList();
}

//! fBXvCXgĂяo
inline void GlDisplayListArray::CallList( GLuint i_ListIdIndex )
{
	glCallList( m_ListID + i_ListIdIndex );
}


}
