#pragma once

#include "GlInclude.h"


namespace lib_gl
{


// ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//! sNZtH[}bgݒ@\
class CPixelFormat
{
public:
	//! 悭gpʓIȐݒ̃sNZtH[}bgԂ
	static const PIXELFORMATDESCRIPTOR& GetStandardPFD(void);

	//! w肵foCXReLXgɑ΂ăsNZtH[}bgݒ肷
	static bool SetPFD( HDC i_hdc , const PIXELFORMATDESCRIPTOR& i_pfd );
	//! sNZtH[}bgGetStandardPFDŐݒ肷
	static bool SetPFD( HDC i_hdc );
};



inline
const PIXELFORMATDESCRIPTOR& CPixelFormat::GetStandardPFD(void)
{
	static const PIXELFORMATDESCRIPTOR default_pfd =
	{
		sizeof (PIXELFORMATDESCRIPTOR),  //\̂̃TCY
		1,                               //OpenGL o[W
		PFD_DRAW_TO_WINDOW |             //EBhEX^C
		PFD_SUPPORT_OPENGL |             //OpenGL g
		PFD_DOUBLEBUFFER,                //_uobt@gp\
		PFD_TYPE_RGBA,                   //sNZ̃J[f[^
		32,                              //F̃rbg
		0, 0,                            //RGBÃrbgƃVtgݒ
		0, 0,                            //G
		0, 0,                            //B
		0, 0,                            //A
		0,                               //AL[Vobt@
		0, 0, 0, 0,                      //RGBAAL[Vobt@
		32,                              //fvXobt@     ̃sNZ̃rbg
		8,                               //XeVobt@ ̃sNZ̃rbg
		0,                               //⏕obt@       ̃sNZ̃rbg
		PFD_MAIN_PLANE,                  //C[^Cv
		0,                               //\ 
		0, 0, 0                          //gp
	};

	return default_pfd;
}


inline
bool CPixelFormat::SetPFD( HDC i_hdc , const PIXELFORMATDESCRIPTOR& i_pfd )
{
	int pixelformat = ChoosePixelFormat( i_hdc , &i_pfd );
	if( pixelformat == 0 ) return false;

	if( SetPixelFormat( i_hdc , pixelformat , &i_pfd ) == FALSE ) return false;

	return true;
}

inline
bool CPixelFormat::SetPFD( HDC i_hdc )
{
	return SetPFD( i_hdc , GetStandardPFD() );
}


}
