#pragma once

#ifdef _WIN32

#include <windows.h>
#include <shlwapi.h>
#pragma comment(lib, "shlwapi")

#include <vector>
#include <iostream>

#include "string_converter.h"



namespace util
{
namespace path
{


//! w肵t@C,tH_tH_̃pXԂ
inline std::string dirname(const std::string &path)
{
	std::vector<char> buf;
	buf.reserve(path.size()+1);
	for(size_t i=0; i<path.size(); ++i)
	{
		if(path[i]=='/')
		{
			buf.push_back('\\');
		}
		else
		{
			buf.push_back(path[i]);
		}
	}
	buf.push_back(0);

	if(!PathRemoveFileSpecA(&buf[0]))
		return "";

	return std::string(&buf[0]);
}

//! w肵t@C,tH_tH_̃pXԂ
inline std::wstring dirname(const std::wstring &path)
{
	std::vector<wchar_t> buf;
	buf.reserve(path.size()+1);
	for(size_t i=0; i<path.size(); ++i)
	{
		if(path[i]==L'/')
		{
			buf.push_back(L'\\');
		}
		else
		{
			buf.push_back(path[i]);
		}
	}
	buf.push_back(0);

	if(!PathRemoveFileSpecW(&buf[0]))
		return L"";

	return std::wstring(&buf[0]);
}

//! JgfBNg擾
inline std::string pwd()
{
	char path[MAX_PATH];
	if(GetCurrentDirectoryA(MAX_PATH, path))
	{
		return path;
	}
	return "";
}

//! JgfBNgݒ肷
inline void cd(const std::string &path)
{
	SetCurrentDirectoryA(path.c_str());
}

//! JgfBNgݒ肷
inline void cd(const std::wstring &path)
{
	SetCurrentDirectoryW(path.c_str());
}


//! st@CpX擾
inline std::string GetAppPath(void)
{
	char buf[MAX_PATH];

	int nLen = ::GetModuleFileName(NULL, buf, MAX_PATH);
	if(nLen <= 0)
		return std::string("");

	return std::string(buf);
}

//! st@C̃tH_pX擾
inline std::string GetAppDirPath(void)
{
	std::string app_path = GetAppPath();

	std::wstring wf;
	util::string::ToUnicode(app_path, wf);

	std::wstring::size_type splitter = wf.find_last_of(L'\\');
	if(splitter == std::wstring::npos)
		splitter = wf.find_last_of(L'/');

	if(splitter == std::wstring::npos)
		return "";

	std::wstring dir_path = wf.substr(0, splitter + 1);

	std::string mp;
	util::string::ToMultiByte(dir_path, mp);

	return mp;
}


}
}


#endif
