#pragma once

#include <vector>

#include <C2/lm/matrix4.h>

#include "NamedElement.h"



namespace lib_geo
{


class ColladaBone;
class ColladaMesh;



class AxisRotation
{
public:
	lm::vec3f m_Axis;
	float     m_Angle;
};


class NodeTransform
{
public:
	lm::matrix4f CreateMatrix(void) const
	{
	}

public:
	lm::vec3f      m_Trans;
	AxisRotation   m_RotX;
	AxisRotation   m_RotY;
	AxisRotation   m_RotZ;
	lm::vec3f      m_Scale;
};


class ColladaNode : public NamedElement
{
public:
	enum NodeTypes
	{
		TYPE_NONE  , 
		TYPE_NODE  , 
		TYPE_JOINT , 
	};

public:
	ColladaNode(void)
		: m_BindMesh(NULL)
		, m_BindBone(NULL)
		, m_Parent(NULL)
		, m_TransMat( lm::matrix4f::get_identity() )
		, m_Type( TYPE_NONE )
	{}

	void ApplyTransMat(lm::vec3f& v) const;
	void ApplyNormalTransMat(lm::vec3f& v) const;

	void SetParent(ColladaNode* parent);

	void UpdateTransmat(void);
	void InitializeInvmat(void);


public:
	std::string             m_BindTargetName;
	ColladaMesh*            m_BindMesh;
	ColladaBone*            m_BindBone;

	ColladaNode*              m_Parent;
	std::vector<ColladaNode>  m_Childs;

	lm::matrix4f       m_TransMat;
	lm::matrix4f       m_TransMatIniInv;

	NodeTransform      m_Transform;

	NodeTypes          m_Type;
};


}
