#pragma once

#include <iostream>
#include <vector>
#include <string>

#include <C2/lm/vector3.h>

#include "PlyFace.h"
#include "PlyHeader.h"


namespace lib_geo
{
class BaseMesh;
}


namespace lib_geo
{
namespace ply
{


class PlyMesh
{
public:
	void Clear(void);

	bool Load( std::istream& ist );
	bool Load( const std::string& i_Filename );
	bool Save( std::ostream& ost ) const;
	bool Save( const std::string& i_Filename ) const;

	bool ConvertToBaseMesh( BaseMesh& o_mesh ) const;


private:
	bool GetNextLine(std::istream& ist, std::string& s) const;

	bool ReadHeader(std::istream& ist);

	bool CheckHeader(const std::string& line, const char* header) const;

	bool ReadAscii( std::istream& ist );
	bool ReadBinary( std::istream& ist , bool is_litle_endian );

public:
	PlyHeader m_Header;
	std::vector<lm::vec3f> m_Verts;
	std::vector<lm::vec3f> m_Normals;
	std::vector<PlyFace> m_Faces;
};


}
}
