#pragma once

#include <LibQtGeoViewerCore/SceneMain.h>

#include <assimp/Importer.hpp>
#include <assimp/scene.h>
#include <assimp/postprocess.h>


class AssimpUtil
{
public:
	static void CopyAIVerts(lib_geo::BaseMesh& mesh_dst, aiMesh* mesh);
	static void CopyAIFaces(lib_geo::BaseMesh& mesh_dst, aiMesh* mesh);
	static lib_graph::color4f AIToColor(aiMaterialProperty* prop);
	static std::string GetTextureNameFromFilePath(const std::string& filepath);
	static void CopyMaterials(MeshBuf* mbuf, const aiScene* ai_scene, SceneMain& scene, const std::string& dirpath);

	static void CreateBoneTree(NodeMap& nodemap, SceneNode* bn);
	static int GetNumKeyOfFrame(const aiNodeAnim* ch);
};


namespace ae
{


void ConvertVec(lm::vec3f& dst, const aiVector3D& src);
void ConvertQuat(lm::quat4f& dst, const aiQuaternion& src);
void ConvertMat(lm::matrix4f& lm, const aiMatrix4x4& am);
void AiQuatToLmQuat(lm::quat4f& lq, const aiQuaternion& aq);


}
