#include "stdafx.h"
#include "MqoLoader.h"

#include "../FileUtil.h"

#include <LibGeo/Mesh/MQO/MqoLoader.h>

#include <LibQtGeoViewerCore/SceneMain.h>



bool MqoLoader::Load(SceneMain& scene, const std::string& filename)
{
	lib_geo::MqoObject mqo_obj;
	lib_geo::MqoLoader loader;
	loader.Load( mqo_obj , filename );

	GeomObject* geom = scene.CreateNewGeometry();
	MeshBuf* mbuf = geom->CreateNewMeshBuf();
	scene.RefreshObjectIndex();

	mqo_obj.ConvertToBaseMesh(mbuf->m_Mesh);

	// eNX`̐ݒ
	mbuf->CreateTextureBuf(mqo_obj.m_Materials.size());
	for (size_t i = 0; i < mqo_obj.m_Materials.size(); ++i)
	{
		const lib_geo::MqoMaterial& mat_source = mqo_obj.m_Materials[i];
		const std::string filepath = mat_source.GetTextureFilePath();
		const std::string name = mat_source.m_Name;

		mbuf->InitColorTexture(i, filepath, name, scene.m_TexConfig);
	}

	geom->m_Name = FileUtil::GetFileTitle(filename);

	geom->m_FileFormat = GeomFileFormat::Mqo;
	geom->m_FilePath = filename;
	geom->InitializeBufferCommon();
	scene.UpdateTransform();

	scene.ReportDoneEditGeometry();

	return true;
}
