#include "stdafx.h"
#include "StlLoader.h"

#include "../FileUtil.h"

#include <LibGeo/Mesh/STL/StlMesh.h>

#include <LibQtGeoViewerCore/SceneMain.h>



bool StlLoader::Load(SceneMain& scene, const std::string& filename)
{
	GeomObject* geom = scene.CreateNewGeometry();
	MeshBuf* mbuf = geom->CreateNewMeshBuf();
	scene.RefreshObjectIndex();
	lib_geo::BaseMesh& mesh_dst = mbuf->m_Mesh;

	lib_geo::StlMesh stl_mesh;
	if (stl_mesh.Load(filename))
	{
		stl_mesh.ConvertToBaseMesh(mesh_dst);
	}

	if (stl_mesh.ExistZeroLengthNormal())
	{
		mesh_dst.CreateNormalsEachVerts();
		mesh_dst.UpdateNormal();
	}

	geom->m_Name = FileUtil::GetFileTitle(filename);

	geom->m_FileFormat = GeomFileFormat::Stl;
	geom->m_FilePath = filename;
	geom->InitializeBufferCommon();
	scene.UpdateTransform();

	scene.ReportDoneEditGeometry();

	return true;
}
