#include "StdAfx.h"
#include "GeomTexture.h"



namespace geom
{


void GeomTextureSet::SetTextureUnit(TextureType type, gl::GlTexture* tex)
{
	switch (type)
	{
	case TextureType::Color  : TexColor  = tex; break;
	case TextureType::Normal : TexNormal = tex; break;
	default:
		assert(false);
		break;
	}
}

bool GeomTextureSet::HasActiveColorTexture(void) const
{
	return IsActiveTexture(TexColor);
}

bool GeomTextureSet::HasActiveNormalTexture(void) const
{
	return IsActiveTexture(TexNormal);
}

bool GeomTextureSet::IsActiveTexture(gl::GlTexture* tex) const
{
	if (tex == NULL)
		return false;
	if (!tex->HasTextureObject())
		return false;
	return true;
}


}
