#pragma once


namespace geom
{


class Bone;


class SceneNode
{
public:
	SceneNode(void)
	{
		m_Bone = NULL;
		m_Parent = NULL;
		m_KeyIdxOffset = 0;
	}

	lm::matrix4f GetFrameTransform(int frame) const;

	int GetKeyframeMax(void) const;

	bool HasKey(void) const;

public:
	std::string m_Name;

	lm::matrix4f m_Transform;
	lm::matrix4f m_WorldTrans;

	Bone* m_Bone;

	SceneNode* m_Parent;
	boost::ptr_vector<SceneNode> m_Children;

	std::vector<lm::vec3f>  m_Translate;
	std::vector<lm::quat4f> m_Rotate;
	std::vector<lm::vec3f>  m_Scale;

	std::vector<int> m_MeshIDs;

	int m_KeyIdxOffset;
};


class GeoNodeTree
{
public:
	void Clear(void)
	{
		m_RootNodes.clear();
	}

	int GetKeyframeMax(void) const;

	void TraceNodeTree(void);
	void TraceNodeTreeN(SceneNode* bn);

public:
	boost::ptr_vector<SceneNode> m_RootNodes;
};


class NodeMap
{
public:
	SceneNode* Find(const std::string& name);

public:
	std::map<std::string, SceneNode*> Bones;
};


}
