#pragma once

#include <QDialog>
#include "ui_CrossSectionConfigDlg.h"



class View3D;
class CrossSectionConfig;
class SceneMain;



class CrossSectionConfigDlg : public QDialog
{
	Q_OBJECT

public:
	CrossSectionConfigDlg(QWidget *parent = 0);
	~CrossSectionConfigDlg();

	void InitializeConfigDlg(View3D* view3d);

signals:
	void ConfigChanged();

protected:
	virtual void keyPressEvent(QKeyEvent *e);

	void UpdateValueLabels(void);

private:
	float GetCSPosValueX(void) const;
	float GetCSPosValueY(void) const;
	float GetCSPosValueZ(void) const;
	float GetRibbonRange(void) const;

	void UpdateSlideEnabled(void);

	void CutAngleChanged(void);

	CrossSectionConfig* GetCSConfig(void);
	const CrossSectionConfig* GetCSConfig(void) const;

	void SyncCameraMove(float diff);

	float GetSliderValueSilentN(const QSlider* s) const;
	void SetSliderValueSilentN(QSlider* s, float val);
	void SetSliderValueSilent(QSlider* s, int val);

	void UpdateCS(bool EnableUpateExt);

	void UpdatePosition(float& dst, float cutpos);

	SceneMain* GetScene(void);
	const SceneMain* GetScene(void) const;

private slots:
	void on_checkTopMost_toggled(bool checked);

	void on_sliderCrossSectionPointX_valueChanged(int value);
	void on_sliderCrossSectionPointY_valueChanged(int value);
	void on_sliderCrossSectionPointZ_valueChanged(int value);

	void on_checkCorssSection_toggled(bool checked);

	void on_checkCorssSectionRibbon_toggled(bool checked);

	void on_sliderCrossSectionRibbonHeight_valueChanged(int value);

	void on_checkLineCS_toggled(bool checked);

	void on_radioDirX_toggled(bool checked);
	void on_radioDirY_toggled(bool checked);
	void on_radioDirZ_toggled(bool checked);
	void on_radioFreeCut_toggled(bool checked);
	void on_checkClipRev_toggled(bool checked);

	void on_checkMultiColor_toggled(bool checked);

	void on_checkShowCrossSectionLength_toggled(bool checked);
	void on_checkShowCrossSectionCHLength_toggled(bool checked);
	void on_checkLengthWhole_toggled(bool checked);
	void on_checkShowConvexHull_toggled(bool checked);
	void on_checkShowCutPlane_toggled(bool checked);

	void on_checkTransparent_toggled(bool checked);

	void on_buttonAddRecord_clicked();
	void on_buttonDelRecord_clicked();

private:
	Ui::CrossSectionConfigDlg ui;

private:
	View3D* m_View3D;
};
