#include "stdafx.h"
#include "DlgAssociationEdit.h"

#include <QProcess>
#include <QDir>
#include <QUrl>
#include <QDesktopServices>

#include <shlobj.h>
#include <shlwapi.h>
#include <objbase.h>

#include "PathInfo.h"



DlgAssociationEdit::DlgAssociationEdit(QWidget *parent)
	: QDialog(parent)
{
	ui.setupUi(this);

	Qt::WindowFlags flags = windowFlags() & (~Qt::WindowContextHelpButtonHint);
	flags = flags | Qt::WindowCloseButtonHint;
	setWindowFlags(flags);
}

void DlgAssociationEdit::SetAssociation(QString ext)
{
	QString mypath = QApplication::applicationFilePath();
	mypath = QDir::toNativeSeparators(mypath);

	QString cmd = PathInfo::GetAsscEditorPath();
	cmd = QDir::toNativeSeparators(cmd);

	//QStringList args;
	//args << ext << mypath;

	QString cmd_ext = "\"" + cmd + "\"";
	QString args = ext + " \"" + mypath + "\"";

	//ShellExecuteA(NULL, cmd_ext.toLocal8Bit().data(), args.toLocal8Bit().data(), NULL, NULL, 0);

	std::string s_ext = cmd_ext.toLocal8Bit().data();
	std::string s_args = args.toLocal8Bit().data();

	SHELLEXECUTEINFOA ShExecInfo;
	ShExecInfo.cbSize = sizeof(SHELLEXECUTEINFOA);
	ShExecInfo.fMask = NULL;
	ShExecInfo.hwnd = NULL;
	ShExecInfo.lpVerb = NULL;
	ShExecInfo.lpFile = s_ext.c_str();
	ShExecInfo.lpParameters = s_args.c_str();
	ShExecInfo.lpDirectory = NULL;
	ShExecInfo.nShow = SW_HIDE;
	ShExecInfo.hInstApp = NULL;

	ShellExecuteExA(&ShExecInfo);

	//QDesktopServices::openUrl(QUrl::fromLocalFile(cmd_ext + " a"));

	//QProcess p;
	//p.start(cmd, args);
}

void DlgAssociationEdit::on_buttonAddObj_clicked()
{
	SetAssociation("obj");
}

void DlgAssociationEdit::on_buttonAddStl_clicked()
{
	SetAssociation("stl");
}

void DlgAssociationEdit::on_buttonAddPly_clicked()
{
	SetAssociation("ply");
}

void DlgAssociationEdit::on_buttonAddMqo_clicked()
{
	SetAssociation("mqo");
}

void DlgAssociationEdit::on_buttonAddX_clicked()
{
	SetAssociation("x");
}

void DlgAssociationEdit::on_buttonAddDae_clicked()
{
	SetAssociation("dae");
}
