#include "stdafx.h"
#include "Border.h"

#include "../PathInfo.h"

#include "../../GLUtility/ShaderUtil.h"



BorderPostproc::BorderPostproc(PostprocContext* context) : 
	PostprocInterface(context)
{
	QString shader_path = PathInfo::GetPostprocCodeDirPath();

	std::string p = shader_path.toLocal8Bit().data();

	std::string frag_filename = p + "Border.frag";
	std::string vert_filename = p + "Border.vert";

	ShaderUtil::InitShaderStd(m_Shader, frag_filename, vert_filename);
}

void BorderPostproc::BeginRender(void)
{
	m_Shader.BeginShader();

	SetStandardSiinglePathPPTextureConfig(m_Shader);
}

void BorderPostproc::EndRender(void)
{
	m_Shader.EndShader();
}
