#pragma once

#include <C2/lm/matrix4.h>

#include "ShaderInterface.h"



class IntegrateShader : public ShaderInterface
{
public:
	IntegrateShader(ShaderContext* context);

	const char* GetShaderName(void)
	{
		return "IntegrateShader";
	}

	bool Initialize(const std::string& shader_libdir);

	virtual void BeginShader(void);
	virtual void EndShader(void);

	virtual bool IsRequireShadowBuf(void) const
	{
		return true;
	}

	virtual void SetColorTextureEnabled(bool enabled);
	virtual void SetTextureSpecularSeparate(bool enabled);

	virtual void SetDublesideEnabled(bool enabled);
	virtual void SetLightingEnabled(bool enabled);
	virtual void SetFlatShade(bool enable_flat);

	virtual void SetNormalTexture(gl::GlTexture* tex_n);
	virtual void SetMatcap(gl::MatcapImage* matcap);

	virtual void SetShadowmap(ShadowBuffer* shadow);

	virtual GLint GetTangentAttribIndex(void);

private:
	GLint GetLocUniform(const GLchar* name);
	GLint GetLocAttrib(const GLchar* name);

private:
	lib_gl::GlslProgram m_Shader;

	GLint m_SeparateSpecular;
	GLint m_EnableDoubleside;
	GLint m_EnableLighting;
	GLint m_EnableFlatShade;

	GLint m_SceneMat;
	GLint m_EnvReflection;
	GLint m_ColorShadowRatio;
	GLint m_EnableHole;
	GLint m_EnableHoleRev;
	GLint m_HolePos;
	GLint m_HoleRange;
	GLint m_ConstBrightness;

	GLint m_TexColor;
	GLint m_EnabeTexture;

	GLint m_TexMatcap;
	GLint m_EnableMatcap;

	GLint m_TexEnvmap;
	GLint m_EnableEnvmap;

	GLint m_TangentBuf;
	GLint m_TexNormal;
	GLint m_EnableNormalmap;

	GLint m_ShadowBuffer;
	GLint m_EnableShadow;
	GLint m_EnableSoftShadow;
	GLint m_ShadowMat;
};
