#include "StdAfx.h"
#include "NormalColorShader.h"


bool NormalColorShader::Initialize(const std::string& shader_libdir)
{
	lib_gl::GlslShader vert;
	if( !vert.CreateFromFile( GL_VERTEX_SHADER , (shader_libdir + "normalcolor_shader.vert").c_str() ) )
		return false;

	lib_gl::GlslShader frag;
	if( !frag.CreateFromFile( GL_FRAGMENT_SHADER , (shader_libdir + "normalcolor_shader.frag").c_str() ) )
		return false;

	if( !m_Program.Create( vert , frag ) )
		return false;

	return true;
}

void NormalColorShader::Release(void)
{
	m_Program.Release();
}

void NormalColorShader::BeginShader(void)
{
	m_Program.BeginShader();
}

void NormalColorShader::EndShader(void)
{
	m_Program.EndShader();
}

