varying vec3 v_position;

uniform sampler2D tex_color;
uniform sampler2D tex_depth;

uniform int tex_width;
uniform int tex_height;



void main (void)
{
	float tx = v_position.x * 0.5 + 0.5;
	float ty = v_position.y * 0.5 + 0.5;
	vec4 uv = vec4(tx, ty, 0.0, 1.0);

	vec4 diff_x = vec4( 1.0 / tex_width , 0.0 , 0.0 , 0.0 );
	vec4 diff_y = vec4( 0.0 , 1.0 / tex_height , 0.0 , 0.0 );

	vec4 src = texture2DProj( tex_color , uv );

	vec4 aa = src * 3.0;
	int adj = 14;
	float ad = 3.0;
	for (int i = 0; i < adj; ++i)
	{
		vec4 sx = diff_x * i;
		vec4 sy = diff_y * i;
		float dn = 1.0 * (adj-i)/(adj+1);
		float rate = dn * 0.5 + 0.5;
		aa += rate * texture2DProj( tex_color , uv + sx ) * 2.0;
		aa += rate * texture2DProj( tex_color , uv + sy ) * 2.0;
		aa += rate * texture2DProj( tex_color , uv - sx ) * 2.0;
		aa += rate * texture2DProj( tex_color , uv - sy ) * 2.0;
		aa += rate * texture2DProj( tex_color , uv + sx + sy );
		aa += rate * texture2DProj( tex_color , uv + sx - sy );
		aa += rate * texture2DProj( tex_color , uv - sx + sy );
		aa += rate * texture2DProj( tex_color , uv - sx - sy );
		ad += rate * 12.0;
	}

	aa /= ad;

	gl_FragColor = aa;
	gl_FragColor.w = 1.0;
}
