#pragma once

#include <sstream>

#include "static_assert.h"


namespace util
{


template<typename To, typename From>
To lexical_cast(const From& i_from)
{
	To result;
	std::stringstream ss;

	ss << i_from;
	ss >> result;

	return result;
}


template<typename From>
class lexical_cast_t
{
public:
	lexical_cast_t( const From& i_from ) : m_from(i_from) {}

	template<class To>
	operator To() const
	{
		return lexical_cast<To>(m_from);
	}

private:
	const From& m_from;
};


//! Ō^𐄑lexical_cast
template<typename From>
lexical_cast_t<From> auto_lexical(const From& i_from)
{
	return lexical_cast_t<From>(i_from);
}


}
