#pragma once

#include <QApplication>

#include "qt5singleapplib_global.h"

class QtLocalPeer;


class QT5SINGLEAPPLIB_EXPORT QtSingleApplication : public QApplication
{
	Q_OBJECT

public:
	QtSingleApplication(int &argc, char **argv, bool GUIenabled = true);
	QtSingleApplication(const QString &id, int &argc, char **argv);

#if QT_VERSION < 0x050000
	QtSingleApplication(int &argc, char **argv, Type type);
#endif // QT_VERSION < 0x050000

	bool isRunning();
	QString id() const;

	void setActivationWindow(QWidget* aw, bool activateOnMessage = true);
	QWidget* activationWindow() const;

	// Obsolete:
	void initialize(bool dummy = true)
	{
		isRunning(); Q_UNUSED(dummy)
	}

public Q_SLOTS:
	bool sendMessage(const QString &message, int timeout = 5000);
	void activateWindow();

Q_SIGNALS:
	void messageReceived(const QString &message);


private:
	void sysInit(const QString &appId = QString());
	QtLocalPeer *peer;
	QWidget *actWin;
};
