#include "stdafx.h"
#include "FileUtil.h"

#include <C2/util/string_util.h>



std::string FileUtil::GetFileTitle(const std::string& filepath)
{
	std::wstring name = util::String::ToUnicode(filepath);

	std::wstring::size_type ext_pos = std::wstring::npos;
	ext_pos = name.find_last_of(L"\\");
	if(ext_pos == std::wstring::npos)
		ext_pos = name.find_last_of(L"/");

	if(ext_pos != std::wstring::npos)
		name = name.substr(ext_pos + 1);

	return util::String::ToMultiByte(name);
}
