#include "stdafx.h"
#include "GeoNodeTree.h"

#include "Skining/Bone.h"



namespace geom
{


int GeoNodeTree::GetKeyframeMax(void) const
{
	int kf = 0;
	for (const SceneNode& n : m_RootNodes)
	{
		kf = (std::max)(kf, n.GetKeyframeMax());
	}

	return kf;
}

void GeoNodeTree::TraceNodeTree(void)
{
	for (SceneNode& n : m_RootNodes)
	{
		TraceNodeTreeN(&n);
	}
}

void GeoNodeTree::TraceNodeTreeN(SceneNode* bn)
{
	static int TraceLayer = 0;

	if (bn == NULL)
		return;

	std::ostringstream s;
	for (int i = 0; i < TraceLayer; ++i)
	{
		s << "|";
	}

	s << "+" << bn->m_Name;
	if (bn->m_Bone != NULL)
		s << "b" << bn->m_Bone->m_Index;

	s << "(" << bn->GetKeyframeMax() << ")";
	s << "[";
	for (int mid : bn->m_MeshIDs)
	{
		s << " " << mid;
	}
	s << " ]";
	s << std::endl;
	OutputDebugStringA(s.str().c_str());

	for (SceneNode& cn : bn->m_Children)
	{
		TraceLayer++;
		TraceNodeTreeN(&cn);
		TraceLayer--;
	}
}


}
