#pragma once

#include <C2/lm/vector3.h>
#include <C2/lm/matrix4.h>
#include <C2/lm/quat4.h>


namespace geom
{


class SceneTransform
{
public:
	//! XYZ̏ɂǂ̕ɑΉ邩\.
	//! RUF -> X=Right, Y=Up, Z=Fore
	enum CoordType
	{
		COORD_RUF,
		COORD_UFR,
		COORD_FRU,
		COORD_RUB,
		COORD_UBR,
		COORD_BRU,
	};

public:
	SceneTransform(void);

	void Reset(void);
	void ResetOnlyRotate(void);

	void SetGLWorldConfig(void);
	void SetGLTransform(void);
	void SetGLTransformOnlyRotate(void);

	void GetRotateMatrix(lm::matrix4f& mat);

	lm::vec3f TransformVec(const lm::vec3f& v) const;
	lm::vec3f InverseTransformVec(const lm::vec3f& v) const;

	void SetScale(float s)
	{
		m_Scale = s;
	}

	float GetScale(void) const
	{
		return m_Scale;
	}

	CoordType GetCoordType(void) const;
	void SetCoordType(CoordType type);

	//! RightHand = OpenGL standard coordinate
	bool IsRightHandCoord(void) const;

	void SetGLForeFaceAngle(void);

private:
	void UpdateQuatRotate(void);


public:
	lm::vec3f  m_Translate;

private:
	CoordType m_CoordType;
	lm::quat4f m_Rotate;

	float m_Scale;
};


class TextureTransform
{
public:
	TextureTransform(void);

	void SetGLTransform(void);

public:
	bool m_FlipY;
	float m_TexScale;
};


}
